package com.bokesoft.yigo.struct.datatable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import com.bokesoft.yes.struct.datatable.Row;

/**
 * 多个索引，主要维系数据的变化
 */
public class Indexes {
	private List<Index> indexes;

	private DataTable rst;

	public Indexes(DataTable rst) {
		this.rst = rst;
	}

	/**
	 * 根据过滤条件取过滤出来的RowIndex
	 * 
	 * @param filterColumns
	 * @param filterValues
	 * @return
	 * @throws Throwable
	 */
	public int[] getFilterRowIndexes(String[] filterColumns, Object[] filterValues) throws Throwable {
		//System.out.println(rst.hashCode() + "\tfilter\t" + ArrayUtils.toString(filterColumns) + "\t" + ArrayUtils.toString(filterValues));
		if (filterColumns.length == 0) {
			int size = rst.size();
			int[] result = new int[size];
			for (int i = 0; i < size; i++) {
				result[i] = i;
			}
			return result;
		}
		return getIndex(filterColumns).filter(filterValues);
	}

	public Object[][] getDistinctValues(String[] filterColumns) throws Throwable {
		return getIndex(filterColumns).getDistinctKeyValues();
	}

//	/**
//	 * 根据过滤条件取所有的值
//	 * 
//	 * @param filters
//	 * @param columnName
//	 *            取值字段
//	 * @param indexFields
//	 *            不包括取值字段的索引字段
//	 * @return
//	 * @throws Throwable
//	 */
//	public List<Object> getGroupValue(IndexFilter[] filters, String columnName,
//			String indexFields) throws Throwable {
//		String newIndexFields = StringUtil.join(indexFields, columnName, ",");
//		return getIndex(newIndexFields).getGroupValue(filters, columnName);
//	}

	/**
	 * 根据过滤条件和已有的索引,取索引对象
	 * 
	 * @param filterColumns
	 * @return
	 */
	private synchronized Index getIndex(String[] filterColumns) {
		if (updateBookmarks != null || insertBookmarks != null || deleteRows != null) {
			for (Index index : indexes) {
				index.updateIndex(updateBookmarks, insertBookmarks, deleteRows);
			}
			updateBookmarks = null;
			insertBookmarks = null;
			deleteRows = null;
			curUpdateBookmark = -1;
		}
		
		if (indexes == null) {
			indexes = new ArrayList<Index>();
		}
		for (Index index : indexes) {
			if (index.isSatisfy(filterColumns)) {
				return index;
			}
		}
		Index newIndex = new Index(rst, filterColumns);
		indexes.add(newIndex);
		return newIndex;
	}

	/** 索引中需要更新的Bookmark */
	private HashSet<Integer> updateBookmarks;
	
	/** 当前正在更新的bookmark，考虑到一次更新多个字段，用这个变更可减少对updateBookmarks的访问 */
	private int curUpdateBookmark = -1;

	/** 索引中需要更新的Bookmark */
	private List<Integer> insertBookmarks;

	/** 索引中被删除的行 */
	private List<Row> deleteRows;
	
	/**
	 * 更新索引数据，修改行
	 */
	public synchronized void updateBookmark(int bookmark) {
		if (curUpdateBookmark == bookmark || indexes == null) {
			return;
		}
		if (updateBookmarks == null) {
			updateBookmarks = new HashSet<Integer>();
		}
		updateBookmarks.add(bookmark);
		curUpdateBookmark = bookmark;
	}
	
	/**
	 * 更新索引数据，新增行
	 */
	public synchronized void insertBookmark(int bookmark) {
		if (indexes == null) {
			return;
		}
		if (insertBookmarks == null) {
			insertBookmarks = new ArrayList<Integer>();
		}
		insertBookmarks.add(bookmark);
		curUpdateBookmark = bookmark;
	}
	
	/**
	 * 更新索引数据，删除行
	 */
	public synchronized void deleteBookmark(Row row) {
		if (indexes == null) {
			return;
		}
		if (deleteRows == null) {
			deleteRows = new ArrayList<Row>();
		}
		deleteRows.add(row);
	}

	/**
	 * 恢复行
	 * @param row
	 */
	public synchronized void recoverBookmark(Row row) {
		if (indexes == null) {
			return;
		}
		if (!deleteRows.remove(row)) {
			insertBookmark(row.getBookmark());
			curUpdateBookmark = -1; // 这一句为了让后面的updateBookmark()切实生效
		}
		updateBookmark(row.getBookmark());
	}	

	public synchronized void clear() {
		if (indexes == null) {
			return;
		}
		for (Index index : indexes) {
			index.clear();
		}
		indexes.clear();
	}
}