package com.bokesoft.yigo.struct.condition;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.condition.ConditionJSONConstants;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.struct.exception.StructException;

/**
 * ConditionParas是以表的形式存放的查询过滤条件参数集
 * 
 * @author 王元和
 *
 */
public class ConditionParas implements JSONSerializable {
	/** 条件界面的表单标识 */
	private String conditionFormKey = "";
	/** 条件 */
	private ArrayList<TranformConditionItem> condItems = new ArrayList<TranformConditionItem>();
	/** 高级条件 */
	private ArrayList<CompConditionItem> compCondItems = new ArrayList<CompConditionItem>();
	/** 条件是否初始化*/
	boolean transed = false;

	public ConditionParas() {
		super();
	}

	public void setConditionFormKey(String conditionFormKey) {
		this.conditionFormKey = conditionFormKey;
	}

	public String getConditionFormKey() {
		return this.conditionFormKey;
	}

	public void add(TranformConditionItem condItem) {
		condItems.add(condItem);
	}

	public ConditionItem get(int index) {
		TranformConditionItem condItem=condItems.get(index);
		if(condItem instanceof ConditionItem) return (ConditionItem) condItem;
		else{
			ConditionItem item=new ConditionItem(condItem.toJSON());
			condItems.set(index, item);
			return item;
		}
//		return (ConditionItem) condItems.get(index);
	}

	public int size() {
		return condItems.size();
	}

	public void clear() {
		condItems.clear();
		compCondItems.clear();
	}
	
	/**
	 * 添加一行高级查询 
	 */
	public void addHighItem(CompConditionItem item) {
		compCondItems.add(item);
	}
	
	/**
	 * 获取高级查询条件 
	 * @throws Throwable 
	 */
	public CompConditionItem getHighItem(int index) throws Throwable {
		return compCondItems.get(index);
	}
	
	/**
	 * 高级查询条件大小 
	 *
	 */
	public int getHighItemsSize() {
		return compCondItems.size();
	} 
	
	/**
	 * 是否已经初始化过
	 * @return
	 */
	public boolean isTransed() {
		return transed;
	}

	/**
	 * 设置已初始化
	 * @param transed
	 */
	public void setTransed(boolean transed) {
		this.transed = transed;
	}

	public String toJSONString() throws SerializationException, JSONException {
		JSONObject json;
		try {
			json = toJSON();

			if (json != null) {
				return json.toString();
			}
		} catch (StructException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "";
	}

	public JSONObject toJSON() throws SerializationException, StructException, JSONException {
		JSONObject jsonObj = new JSONObject();
		JSONArray tableArray = new JSONArray();
		jsonObj.put(ConditionJSONConstants.CONDPARAS_CONDFOMRKEY, this.conditionFormKey);

		for (TranformConditionItem item : condItems) {
			tableArray.put(item.toJSON());
		}

		jsonObj.put(ConditionJSONConstants.CONDPARAS_ITEMS, tableArray);
		
		// 添加高级查询
		JSONArray highArray = new JSONArray();
		for (CompConditionItem item : compCondItems) {
			highArray.put(item.toJSON());
		}

		jsonObj.put(ConditionJSONConstants.CONDPARAS_HIGHITEMS, highArray);
		return jsonObj;
	}

	public void fromJSON(JSONObject json) throws SerializationException, JSONException {
		this.conditionFormKey = json.optString(ConditionJSONConstants.CONDPARAS_CONDFOMRKEY);
		JSONArray tableArray = json.has(ConditionJSONConstants.CONDPARAS_ITEMS) ? json.getJSONArray(ConditionJSONConstants.CONDPARAS_ITEMS) : new JSONArray();
		condItems.clear();

		for (int i = 0; i < tableArray.length(); i++) {
			JSONObject itemObj = tableArray.getJSONObject(i);
			ConditionItem item = new ConditionItem(itemObj);
			condItems.add(item);
		}
		
		JSONArray advanArray = json.has(ConditionJSONConstants.CONDPARAS_HIGHITEMS) ? json.getJSONArray(ConditionJSONConstants.CONDPARAS_HIGHITEMS) : new JSONArray();
		compCondItems.clear();

		for (int i = 0; i < advanArray.length(); i++) {
			JSONObject itemObj = advanArray.getJSONObject(i);
			CompConditionItem item = new CompConditionItem(itemObj);
			compCondItems.add(item);
		}

	}
}
