package com.bokesoft.yigo.struct.condition;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.struct.condition.ConditionJSONConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DictStateMask;
import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.common.MetaCondition;

public class ConditionItem extends TranformConditionItem {

	// 以下的内容均从配置对象中获取，不需要进行序列化
	/** 查询条件 */
	private int condSign = -1;
	/** 条件组标识 */
	private String group = "";
	/** 条件组头标志 */
	private boolean groupHead = false;
	/** 条件组尾标志 */
	private boolean groupTail = false;
	/** 条件关联的数据表标识 */
	private String tableKey = "";
	/** 条件关联的数据列标识 */
	private String columnKey = "";
	/** 定制条件的实现类 */
	private String impl = "";
	/** 条件的标识 */
	private String tag = "";
	/** 查询的目标 */
	private String target = "";
	/** 查询条件配置对象 */
	private MetaCondition metaObject = null;
	/** 条件关联的数据表的明细表标识 */
	private String subTableKey = "";
	/** 是否仅在getConditionFilter公式中使用 */
	private boolean onlyFilter = false;

	public ConditionItem() {
	}

	public ConditionItem(JSONObject itemObj) throws SerializationException,
			JSONException {
		fromJSON(itemObj);
	}
	public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
		super.fromJSON(jsonObj);
		target = JSONHelper.readFromJSON(jsonObj,"target", "");
		columnKey = JSONHelper.readFromJSON(jsonObj,"columnKey", "");
		impl = JSONHelper.readFromJSON(jsonObj,"impl", "");
		tag = JSONHelper.readFromJSON(jsonObj,"tag", "");
		onlyFilter = JSONHelper.readFromJSON(jsonObj,"onlyFilter", false);
		subTableKey = JSONHelper.readFromJSON(jsonObj,"subTableKey", "");
		tableKey = JSONHelper.readFromJSON(jsonObj,"tableKey", "");
		group = JSONHelper.readFromJSON(jsonObj,"group", "");
		condSign = JSONHelper.readFromJSON(jsonObj,"condSign", -1);
		groupHead = JSONHelper.readFromJSON(jsonObj,"groupHead", false);
		groupTail = JSONHelper.readFromJSON(jsonObj,"groupTail", false);
	}
	public void setCondSign(int condSign) {
		this.condSign = condSign;
	}

	public int getCondSign() {
		return this.condSign;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	public String getGroup() {
		return this.group;
	}

	public void setGroupHead(boolean groupHead) {
		this.groupHead = groupHead;
	}

	public boolean isGroupHead() {
		return this.groupHead;
	}

	public void setGroupTail(boolean groupTail) {
		this.groupTail = groupTail;
	}

	public boolean isGroupTail() {
		return this.groupTail;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	public String getTableKey() {
		return this.tableKey;
	}

	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}

	public String getColumnKey() {
		return this.columnKey;
	}

	/**
	 * 设置定制条件实现类
	 *
	 * @param impl
	 *            定制条件实现类
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}

	/**
	 * 取得定制条件实现类
	 *
	 * @return 定制条件实现类
	 */
	public String getImpl() {
		return this.impl;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

	/**
	 * 设置查询配置对象
	 * @param metaObject 查询配置对象
	 */
	public void setMetaObject(MetaCondition metaObject) {
		this.metaObject = metaObject;
	}

	/**
	 * 取得查询配置对象
	 * @return 查询配置对象
	 */
	public MetaCondition getMetaObject() {
		return this.metaObject;
	}

	/**
	 * 获取条件关联的数据表的明细表标识
	 * @return 条件关联的数据表的明细表标识
	 */
	public String getSubTableKey() {
		return subTableKey;
	}

	/**
	 * 设置条件关联的数据表的明细表标识
	 * @param subTableKey
	 */
	public void setSubTableKey(String subTableKey) {
		this.subTableKey = subTableKey;
	}

	/**
	 * 是否仅在getConditionFilter公式中使用
	 * @return
	 */
	public boolean isOnlyFilter() {
		return onlyFilter;
	}

	/**
	 * 设置是否仅在getConditionFilter公式中使用
	 * @param onlyFilterFunction
	 */
	public void setOnlyFilter(boolean onlyFilter) {
		this.onlyFilter = onlyFilter;
	}

	public void copyValue(MetaCondition condition) {
		setColumnKey(condition.getColumnKey());
		setCondSign(condition.getSign());
		setGroup(condition.getGroup());
		setGroupHead(condition.isGroupHead());
		setGroupTail(condition.isGroupTail());
		setImpl(condition.getImpl());
		setTableKey(condition.getTableKey());
		setTag(condition.getTag());
		if (this.getType() != ControlType.DYNAMICDICT){
			setTarget(condition.getTarget());
		}
		setSubTableKey(condition.getSubTableKey());
		setOnlyFilter(condition.isOnlyFilter());
	}

	public ConditionItem clone() {
		ConditionItem newItem = new ConditionItem();
		newItem.setColumnKey(columnKey);
		newItem.setCondSign(condSign);
		newItem.setGroup(group);
		newItem.setGroupHead(groupHead);
		newItem.setGroupTail(groupTail);
		newItem.setImpl(impl);
		newItem.setTableKey(tableKey);
		newItem.setSubTableKey(subTableKey);
		newItem.setOnlyFilter(onlyFilter);
		cloneValue(newItem);
		return newItem;
	}

}
