package com.bokesoft.yigo.struct.condition;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.condition.ConditionJSONConstants;
import com.bokesoft.yigo.common.def.BracketType;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.def.LogicalSymbol;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.exception.StructException;

/**
 * 查询表格一行数据的封装对象 
 * 左括号 字段 比较符 条件值 右括号 逻辑值
 *
 */
public class CompConditionItem implements JSONSerializable, IConditionItem{
	/** 左括号*/
	private int leftBrac = BracketType.NONE;
	/** (绑定控件key)字段 */
	private String key = "";
	/** 比较符号*/
	private int sign = CondSign.NONE;
	/** 条件值*/
	private Object value = "";
	/** 右括号*/
	private int rightBrac = BracketType.NONE;
	/** 逻辑值*/
	private int logical = LogicalSymbol.NONE;
	
	/** 条件关联的数据表标识 */
	private String tableKey = "";
	/** 条件关联的数据列标识 */
	private String columnKey = "";
	
	// 记录控件的特殊属性
	/** 查询字段类型 (日期控件和字典控件部分属性需要处理)*/
	private int type = -1;
	/** 日期控件是否不带有时间 */
	private boolean onlyDate = true;
	/** 字典itemKey 复合字典做查询条件时用*/
	private String itemKey = "";
	/** 字典状态过滤条件*/
	private int stateMask = DictStateMask.All;	
	private JSONObject filter = null;
	
	public CompConditionItem() {};
	
	public CompConditionItem(JSONObject jsonObj) {
		try {
			fromJSON(jsonObj);
		} catch (StructException e) {
			throw new RuntimeException("HighConditionItem JSON parse fail");
		}
	}
	
	@Override
	public JSONObject toJSON() throws StructException, JSONException {
		JSONObject jsonObj = new JSONObject();
		
		jsonObj.put(ConditionJSONConstants.HIGH_LBRAC, leftBrac);
		jsonObj.put(ConditionJSONConstants.HIGH_KEY, key);
		jsonObj.put(ConditionJSONConstants.HIGH_SIGN, sign);
		
		JSONHelper.writeToJSON(jsonObj, ConditionJSONConstants.HIGH_TYPE, type, -1);		
		jsonObj.put(ConditionJSONConstants.HIGH_VALUE, value2Json(type, value));
		
		jsonObj.put(ConditionJSONConstants.HIGH_RBRAC, rightBrac);
		jsonObj.put(ConditionJSONConstants.HIGH_LOGICAL, logical);
		
		jsonObj.put(ConditionJSONConstants.HIGH_TABLE_KEY, tableKey);
		jsonObj.put(ConditionJSONConstants.HIGH_COLUMN_KEY, columnKey);

		jsonObj.put(ConditionJSONConstants.HIGH_ONLYDATE, onlyDate);
		jsonObj.put(ConditionJSONConstants.HIGH_ITEMKEY, itemKey);
		JSONHelper.writeToJSON(jsonObj, ConditionJSONConstants.HIGH_STATEMASK, stateMask, DictStateMask.All);
		jsonObj.put(ConditionJSONConstants.HIGH_FILTER, filter);
		
		return jsonObj;
	}
	
	@Override
	public void fromJSON(JSONObject jsonObj) throws SerializationException,JSONException {
		leftBrac = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.HIGH_LBRAC,0);
		key = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.HIGH_KEY,"");
		sign = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.HIGH_SIGN, -1);
		
		type = JSONHelper.readFromJSON(jsonObj,ConditionJSONConstants.HIGH_TYPE, -1);
		
		value = json2Value(type, jsonObj.opt(ConditionJSONConstants.HIGH_VALUE));
		rightBrac = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.HIGH_RBRAC,0);
		logical = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.HIGH_LOGICAL,0);
		
		tableKey = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.HIGH_TABLE_KEY, "");
		columnKey = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.HIGH_COLUMN_KEY, "");
		
		onlyDate = JSONHelper.readFromJSON(jsonObj,ConditionJSONConstants.HIGH_ONLYDATE, true);
		itemKey = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.HIGH_ITEMKEY,"");
		stateMask = JSONHelper.readFromJSON(jsonObj, ConditionJSONConstants.HIGH_STATEMASK,DictStateMask.All);
		filter = jsonObj.optJSONObject(ConditionJSONConstants.COND_FILTER);
	}
	
	/**
	 * 根据控件类型转换value转json
	 * 日期 ,字典
	 * 
	 */
	private Object value2Json(int controlType, Object value)
			throws SerializationException, JSONException {
		if (value == null) {
			return value;
		}
		Object ret = null;
		switch (controlType) {
		case ControlType.DATEPICKER:
			ret = TypeConvertor.toDate(value).getTime();
			break;
		case ControlType.DICT:
		case ControlType.COMPDICT:
		case ControlType.DYNAMICDICT:
			if (value instanceof ItemData) {
				ret = ((ItemData) value).toJSON();
			} else if (value instanceof List<?>) {
				JSONArray jsonArray = new JSONArray();
				@SuppressWarnings("unchecked")
				List<ItemData> list = (List<ItemData>) value;
				for (ItemData itemData : list) {
					jsonArray.put(itemData.toJSON());
				}
				ret = jsonArray;
			}
			break;
		default:
			ret = value;
		}
		return ret;
	}
	
	/**
	 * 
	 * 根据控件类型json转value 
	 * 日期 ,字典
	 * 
	 */
	private Object json2Value(int controlType, Object value)
			throws StructException, JSONException {
		Object ret = null;
		switch (controlType) {
		case ControlType.DATEPICKER:
			ret = new Date(TypeConvertor.toLong(value));
			break;
		case ControlType.DICT:
		case ControlType.COMPDICT:
		case ControlType.DYNAMICDICT:
			if (value instanceof JSONArray) {
				List<ItemData> list = new ArrayList<ItemData>();
				JSONArray jsonArray = (JSONArray) value;
				JSONObject itemObj;

				for (int i = 0; i < jsonArray.length(); i++) {
					itemObj = jsonArray.getJSONObject(i);
					list.add(new ItemData(itemObj));
				}
				ret = list;

			} else if (value instanceof JSONObject) {
				ret = new ItemData((JSONObject) value);
			}

			break;
		default:
			ret = value;
		}
		return ret;
	}

	public int getLeftBrac() {
		return leftBrac;
	}

	public void setLeftBrac(int leftBrac) {
		this.leftBrac = leftBrac;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public int getSign() {
		return sign;
	}

	public void setSign(int sign) {
		this.sign = sign;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	public int getRightBrac() {
		return rightBrac;
	}

	public void setRightBrac(int rightBrac) {
		this.rightBrac = rightBrac;
	}

	public int getLogical() {
		return logical;
	}

	public void setLogical(int logical) {
		this.logical = logical;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public boolean isOnlyDate() {
		return onlyDate;
	}

	public void setOnlyDate(boolean onlyDate) {
		this.onlyDate = onlyDate;
	}
	
	public String getItemKey(){
		return this.itemKey;
	}
	
	public void setItemKey(String itemKey){
		this.itemKey = itemKey;
	}

	public int getStateMask(){
		return this.stateMask;
	}
	
	public void setStateMask(int stateMask){
		this.stateMask = stateMask;
	}
	
	public JSONObject getFilter(){
		return this.filter;
	}
	
	public void setFilter(JSONObject filter){
		this.filter = filter;
	}
	
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	public String getTableKey() {
		return this.tableKey;
	}

	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}

	public String getColumnKey() {
		return this.columnKey;
	}
}
