/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.dict;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.dict.ItemData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class BaseItem
implements JSONSerializable {
    private String itemKey;
    private long oid;
    private String caption;
    private int enable;
    private int nodeType;
    private Map<String, Object> props = null;

    public BaseItem(JSONObject jsonObj) {
        try {
            this.fromJSON(jsonObj);
        }
        catch (Throwable e) {
            throw new SerializationException(1, "BaseItem json \u5e8f\u5217\u5316\u9519\u8bef:" + jsonObj);
        }
    }

    public BaseItem(String itemKey, long oid) {
        this.itemKey = itemKey;
        this.oid = oid;
        this.props = new HashMap<String, Object>();
    }

    public void setOID(long oid) {
        this.oid = oid;
    }

    public long getOID() {
        return this.oid;
    }

    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setEnable(int enable) {
        this.enable = enable;
    }

    public int getEnable() {
        return this.enable;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setValue(String colKey, Object value) {
        if (colKey.equalsIgnoreCase("NodeType")) {
            this.nodeType = TypeConvertor.toInteger((Object)value);
        } else if (colKey.equalsIgnoreCase("Enable")) {
            this.enable = TypeConvertor.toInteger((Object)value);
        }
        this.props.put(colKey, value);
    }

    public Object getValue(String colKey) {
        return this.props.get(colKey);
    }

    public String toString() {
        return this.getItemKey() + "_" + this.oid;
    }

    public ItemData toItemData() {
        return new ItemData(this.getItemKey(), this.oid);
    }

    public Set<String> getColKeys() {
        return this.props.keySet();
    }

    public JSONObject toJSON() throws Throwable {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("itemKey", (Object)this.getItemKey());
        jsonObj.put("oid", this.oid);
        jsonObj.put("caption", (Object)this.caption);
        for (String key : this.props.keySet()) {
            jsonObj.put(key, this.props.get(key));
        }
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws Throwable {
        this.oid = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"oid", (long)0L);
        this.itemKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"itemKey", (String)"");
        this.caption = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"caption", (String)"");
        this.props = new HashMap<String, Object>();
        Iterator keys = jsonObj.keys();
        while (keys.hasNext()) {
            String key = TypeConvertor.toString(keys.next());
            if (key.equalsIgnoreCase("NodeType")) {
                this.nodeType = TypeConvertor.toInteger((Object)jsonObj.get(key));
            } else if (key.equalsIgnoreCase("Enable")) {
                this.enable = TypeConvertor.toInteger((Object)jsonObj.get(key));
            }
            this.props.put(key, jsonObj.get(key));
        }
    }
}

