/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.struct.dict;

import com.bokesoft.yes.struct.dict.ItemTableMetaData;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDictQueryStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

public class ItemTableMetaDatas
extends ConcurrentSkipListMap<String, ItemTableMetaData> {
    private static final long serialVersionUID = 1L;
    private String itemKey;
    private String mainTableKey;
    private int type;
    private Map<String, List<String>> i18nColumns = new HashMap<String, List<String>>();
    private String content = null;

    public ItemTableMetaDatas(MetaDataObject dataObj) {
        this.itemKey = dataObj.getKey();
        this.mainTableKey = dataObj.getMainTableKey();
        MetaDictQueryStatement dictQueryStatement = dataObj.getDictQueryStatement();
        if (dictQueryStatement != null) {
            this.content = dictQueryStatement.getContent();
        }
    }

    public void init() {
        for (ItemTableMetaData table : this.values()) {
            this.i18nColumns.put(table.getKey(), table.getI18nColumns());
        }
    }

    public Map<String, List<String>> getI18nColumns() {
        return this.i18nColumns;
    }

    public ItemTableMetaData getMainTable() {
        return (ItemTableMetaData)this.get(this.mainTableKey);
    }

    public String getMainTableName() {
        String tableName = ((ItemTableMetaData)this.get(this.mainTableKey)).getTableName();
        return tableName;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public void setSecondaryType(int type) {
        this.type = type;
    }

    public int getSecondaryType() {
        return this.type;
    }

    public String getQueryStatement() {
        return this.content;
    }
}

