/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.struct.dict;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.dict.ItemRow;
import com.bokesoft.yigo.struct.exception.StructException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ItemTableBase
implements Serializable {
    private static final long serialVersionUID = 2545532255177521274L;
    private List<ItemRow> rows = new ArrayList<ItemRow>();
    private String key;
    private int tableMode;
    private String itemKey;

    public ItemTableBase(String itemKey) {
        this.itemKey = itemKey;
    }

    public ItemTableBase(JSONObject tableObj) throws JSONException {
        try {
            this.fromJSON(tableObj);
        }
        catch (StructException e) {
            e.printStackTrace();
        }
    }

    public ItemTableBase() {
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String sKey) {
        this.key = sKey;
    }

    public int getTableMode() {
        return this.tableMode;
    }

    public void setTableMode(int tableMode) {
        this.tableMode = tableMode;
    }

    public void addItemRow(ItemRow tr) {
        this.rows.add(tr);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public List<ItemRow> getRows() {
        return this.rows;
    }

    public boolean isHeadMode() {
        return this.tableMode == 0;
    }

    public boolean existsColKey(String colKey) {
        if (this.rows.size() > 0) {
            return this.rows.get(0).existColKey(colKey);
        }
        return false;
    }

    public Object getValue(String sField) {
        Object[] value = null;
        if (this.rows.size() > 0) {
            if (this.isHeadMode()) {
                value = this.rows.get(0).getValue(sField);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                for (ItemRow row : this.rows) {
                    list.add(row.getValue(sField));
                }
                value = list.toArray(new Object[0]);
            }
        }
        return value;
    }

    public boolean impl_existsColKey(String colKey) {
        if (this.rows.size() > 0) {
            return this.rows.get(0).impl_existsColKey(colKey);
        }
        return false;
    }

    public Object impl_getValue(String sField) {
        Object[] value = null;
        if (this.rows.size() > 0) {
            if (this.isHeadMode()) {
                value = this.rows.get(0).impl_getValue(sField);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                for (ItemRow row : this.rows) {
                    list.add(row.impl_getValue(sField));
                }
                value = list.toArray(new Object[0]);
            }
        }
        return value;
    }

    public JSONObject toJSON() throws SerializationException, JSONException {
        JSONObject jsonObj = new JSONObject();
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"key", (String)this.key, (String)"");
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"itemKey", (String)this.itemKey, (String)"");
        jsonObj.put("tableMode", this.tableMode);
        JSONArray tableArray = new JSONArray();
        for (ItemRow row : this.rows) {
            JSONObject rowObject = row.toJSON();
            tableArray.put((Object)rowObject);
        }
        jsonObj.put("itemRows", (Object)tableArray);
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        this.key = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"key", (String)"");
        this.itemKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"itemKey", (String)"");
        if (this.itemKey == null || this.itemKey.length() == 0) {
            throw new RuntimeException("ItemTableBase \u5e8f\u5217\u5316\u9519\u8bef \uff0c \u7f3a\u5c11itemKey");
        }
        this.tableMode = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"tableMode", (int)0);
        JSONArray rowArray = jsonObj.getJSONArray("itemRows");
        this.rows.clear();
        for (int i = 0; i < rowArray.length(); ++i) {
            JSONObject rowObj = rowArray.getJSONObject(i);
            ItemRow row = new ItemRow();
            row.fromJSON(rowObj);
            this.rows.add(row);
        }
    }

    private void writeObject(ObjectOutputStream out) {
        try {
            out.writeUTF(this.key);
            out.writeUTF(this.itemKey);
            out.writeInt(this.tableMode);
            out.writeObject(this.rows);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream in) {
        try {
            this.key = in.readUTF();
            this.itemKey = in.readUTF();
            this.tableMode = in.readInt();
            this.rows = (List)in.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public ItemTableBase clone() {
        ItemTableBase itb = new ItemTableBase();
        itb.key = this.key;
        itb.itemKey = this.itemKey;
        itb.tableMode = this.tableMode;
        ArrayList<ItemRow> lists = new ArrayList<ItemRow>();
        for (ItemRow row : this.rows) {
            lists.add(row.clone());
        }
        itb.rows = lists;
        return itb;
    }
}

