/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.util;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.common.Result;
import com.bokesoft.yes.bpm.engine.common.StatusUtil;
import com.bokesoft.yes.bpm.engine.data.row.RTransaction;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecInline;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.node.ExecUserTask;
import com.bokesoft.yes.bpm.engine.node.item.ItemNode;
import com.bokesoft.yes.bpm.engine.util.ProcessUtil;
import com.bokesoft.yes.bpm.meta.transform.WorkitemInfo;
import com.bokesoft.yes.bpm.workitem.TransitData;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.TreeSet;
import org.json.JSONObject;

public class CommitWorkitemUtil {
    public static void commitWorkitem(BPMContext bPMContext, WorkitemInfo object) throws Throwable {
        MetaProcess object32;
        BPMInstance bPMInstance;
        Workitem workitem = CommitWorkitemUtil.loadWorkitem(bPMContext, object);
        if (workitem == null) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)6, (Object[])new Object[0]);
        }
        bPMContext = BPMContext.getBPMContext(bPMContext, workitem.getInstanceID());
        bPMContext.setUpdateWorkitem(workitem);
        if (!StringUtil.isBlank((String)workitem.getInlinePara())) {
            bPMContext.ensureParas();
            bPMContext.getParas().put("inlinePara", (Object)workitem.getInlinePara());
            bPMInstance = new JSONObject(workitem.getInlinePara());
            if (bPMInstance.has("tokenId")) {
                bPMContext.setActiveTokenID(bPMInstance.getInt("tokenId"));
            }
        }
        if ((bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, workitem.getInstanceID())).getInstanceData().getInstance().getData().getInstanceState() == 4) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)23, (Object[])new Object[0]);
        }
        long l2 = object.getSrcOperator() > 0L ? object.getSrcOperator() : bPMContext.getCurUserID().longValue();
        Object object2 = bPMContext.getProcesskey();
        int n2 = bPMContext.getVerID();
        if (!workitem.getParticipatorList().contains(l2)) {
            BPMContext bPMContext2 = bPMContext;
            if (!ProcessUtil.isProcessAdministrator(bPMContext2, bPMContext2.getUserID(), (String)object2, n2)) {
                throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)24, (Object[])new Object[0]);
            }
        }
        bPMContext.setOperationType(object.getOperationType());
        MetaProcess metaProcess = object32 = BPMUtil.getProcessByInstance(bPMContext, bPMInstance);
        if (workitem.getInlineNodeID() > 0) {
            String string = BPMUtil.getInlineProcessKey((MetaInline)BPMUtil.getNode(bPMContext.getVE(), metaProcess, workitem.getInlineNodeID()), (DefaultContext)bPMContext, workitem.getInstanceID());
            metaProcess = BPMUtil.getProcessDefinationByDeployKey(bPMContext.getVE(), string);
        }
        if (object.getOperationType() == 2) {
            WorkitemUtil.unlockWorkitem(bPMContext, workitem.getNodeID(), workitem.getInstanceID(), metaProcess);
            if (workitem.getTransits().size() <= 0) {
                throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)28, (Object[])new Object[0]);
            }
            object2 = workitem.getTransits().values().iterator();
            while (object2.hasNext()) {
                ((TransitData)object2.next()).setKeepParts(object.getKeepParts());
            }
        } else if (object.getBackSite() != null && object.getBackSite().length() > 0 && object.getOperationType() == 1) {
            bPMContext.setBackSite(object.getBackSite());
            bPMContext.setTransitTo(workitem.getNodeID());
            bPMContext.setBackSiteWorkitemID(object.getWorkitemID());
            bPMContext.setBackSiteOpt(object.getBackSiteOpt());
            bPMContext.setAllowTransit(object.isAllowTransit());
        }
        if (object.getSrcOperator() > 0L) {
            bPMContext.setSrcOperator(object.getSrcOperator());
        }
        if (object.getStraightSite() > 0) {
            bPMContext.setStraightSite(object.getStraightSite());
        }
        if (bPMInstance != null) {
            object2 = bPMInstance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID());
            if (object2 instanceof ItemNode) {
                RWorkitem rWorkitem;
                RTransaction rTransaction = new RTransaction(workitem.getInstanceID());
                rTransaction.setTransactionID(bPMInstance.getInstanceData().getInstance().getData().getTransactionID());
                rTransaction.setWorkitemID(workitem.getWorkItemID());
                rTransaction.setOperatorID(bPMContext.getCurUserID());
                rTransaction.setworkitemRevoke(((ExecNode)((Object)object2)).getNodeModel().isWorkitemRevoke());
                rTransaction.setStatusValue(StatusUtil.getStatusValue(bPMContext));
                bPMInstance.getInstanceData().getTransaction().addRow(rTransaction);
                if (object.getStatus() != -1 && object.getOperationType() == 1) {
                    StatusUtil.changeStatusValue(bPMContext, object.getStatus());
                }
                if ((rWorkitem = bPMInstance.getInstanceData().getWorkitemData().getWorkitemData(bPMContext, workitem.getWorkItemID())).getTransferType() == 3) {
                    rTransaction.setworkitemRevoke(false);
                }
                if (rWorkitem.getWorkitemState() == 2) {
                    throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)5, (Object[])new Object[0]);
                }
                if (rWorkitem.getWorkitemState() == 3) {
                    throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)25, (Object[])new Object[]{"Hide"});
                }
                ((ItemNode)object2).getItemProxy().updateWorkitem(bPMContext);
                if ((((ExecNode)((Object)object2)).getNodeType() == 3 || ((ExecNode)((Object)object2)).getNodeType() == 2) && ((MetaUserTask)((ExecNode)((Object)object2)).getNodeModel()).getNodeMessage().getConsumer().isReceiveMessage().booleanValue()) {
                    bPMInstance.getInstanceData().getTransaction().deleteRow(rTransaction);
                }
            }
            if (object.getOperationType() == 2) {
                bPMInstance.getInstanceData().getTransitTo().deleteRows(object.getWorkitemID(), bPMContext.getDBManager());
            } else if (object.getBackSite() != null && object.getBackSite().length() > 0 && object.getOperationType() == 1 && (!object.isAllowTransit() || CommitWorkitemUtil.checkBackToInline(object, workitem, bPMInstance) || CommitWorkitemUtil.checkBackToMainProcess(object))) {
                if (object.getBackSite().indexOf(".") > 0) {
                    n2 = TypeConvertor.toInteger((Object)object.getBackSite().split("\\.")[1]);
                    WorkitemUtil.lockWorkitem(bPMContext, n2, bPMInstance.getInstanceID(), object32);
                } else {
                    n2 = TypeConvertor.toInteger((Object)object.getBackSite());
                    WorkitemUtil.lockWorkitem(bPMContext, n2, bPMInstance.getInstanceID(), metaProcess);
                }
                int n3 = bPMInstance.getMainInstance().getInstanceData().getNode().getNodeData(n2, bPMContext.getDBManager()).getCountSeed();
                TreeSet<Long> treeSet = bPMInstance.getMainInstance().getInstanceData().getWorkitemInfo().getWorkitemIDByNodeID(n2, n3, bPMContext.getDBManager());
                if (CommitWorkitemUtil.checkBackToInline(object, workitem, bPMInstance)) {
                    ExecUserTask execUserTask;
                    for (Long l3 : ((ExecInline)bPMInstance.getNodeByID(-1, n2)).getInlineVirtualInstance().getInstanceData().getWorkitemInfo().getAllWorkitemID(bPMContext.getDBManager())) {
                        treeSet.add(l3);
                    }
                    object = bPMInstance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID());
                    if (object instanceof ExecUserTask && (execUserTask = (ExecUserTask)object2).getJoin() != null) {
                        object.getVirtualInstance().getInstanceData().getToken().deleteTokenByNodeID(execUserTask.getJoin().getID(), bPMContext.getDBManager());
                    }
                }
                if (treeSet != null && treeSet.size() > 0) {
                    for (Long l4 : treeSet) {
                        bPMInstance.getInstanceData().getTransitTo().deleteRows(l4, bPMContext.getDBManager());
                    }
                }
            }
        }
        object2 = bPMInstance.getMainInstance().getWorkitemData().getWorkitemData(bPMContext, workitem.getWorkItemID());
        if (bPMContext.getOperationType() == 2) {
            Object object3 = object2;
            ((RWorkitem)((Object)object3)).setMarkState(((RWorkitem)((Object)object3)).getMarkState() | 0x10);
        } else if (bPMContext.getOperationType() == 1) {
            Object object4 = object2;
            ((RWorkitem)((Object)object4)).setMarkState(((RWorkitem)((Object)object4)).getMarkState() | 0x20);
        }
        bPMContext.getInstanceDataContainer().save();
    }

    private static boolean checkBackToInline(WorkitemInfo workitemInfo, Workitem workitem, BPMInstance bPMInstance) {
        boolean bl = false;
        if (workitemInfo.getBackSite() != null && workitemInfo.getBackSite().length() > 0) {
            int n2;
            int n3 = -1;
            if (workitemInfo.getBackSite().indexOf(".") == -1) {
                n3 = workitem.getInlineNodeID();
                n2 = TypeConvertor.toInteger((Object)workitemInfo.getBackSite());
            } else {
                n2 = TypeConvertor.toInteger((Object)workitemInfo.getBackSite().split("\\.")[1]);
            }
            if (n3 != -1) {
                return false;
            }
            if (bPMInstance.getNodeByID(n3, n2).getNodeType() == 12) {
                bl = true;
            }
        }
        return bl;
    }

    private static boolean checkBackToMainProcess(WorkitemInfo workitemInfo) {
        boolean bl = false;
        if (workitemInfo.getBackSite() != null && workitemInfo.getBackSite().length() > 0 && workitemInfo.getBackSite().indexOf(".") > 0) {
            bl = true;
        }
        return bl;
    }

    private static Workitem loadWorkitem(BPMContext object, WorkitemInfo workitemInfo) throws Throwable {
        if ((object = WorkitemUtil.loadWorkitem((DefaultContext)object, workitemInfo.getWorkitemID())) == null) {
            return null;
        }
        ((Workitem)object).setAuditResult(workitemInfo.getAuditResult());
        ((Workitem)object).setUserInfo(workitemInfo.getUserInfo());
        ((Workitem)object).setResultInfo(Result.parseToString(workitemInfo.getAuditResult()));
        ((Workitem)object).setOperationKey(workitemInfo.getOperationKey());
        ((Workitem)object).setNextOpStr(workitemInfo.getNextOpStr());
        ((Workitem)object).setEndorserID(workitemInfo.getEndorserID());
        ((Workitem)object).setOperationType(workitemInfo.getOperationType());
        return object;
    }
}

