/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.common.Result;
import com.bokesoft.yes.bpm.engine.common.StatusUtil;
import com.bokesoft.yes.bpm.engine.data.row.RTransaction;
import com.bokesoft.yes.bpm.engine.data.virtual.table.VTToken;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.meta.transform.WorkitemInfo;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.util.SysTopicUtil;
import com.bokesoft.yes.bpm.workitem.TransitData;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cache.Row;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.struct.document.Document;
import java.sql.Timestamp;
import org.json.JSONObject;

public class TransferToNodeCmd
extends BPMServiceCmd {
    public static final String TAG = "TransferToNode";
    private WorkitemInfo workitemInfo = null;
    private Document document;

    public TransferToNodeCmd() {
    }

    public TransferToNodeCmd(Long l2, int n2, String string) {
        this.workitemInfo = new WorkitemInfo();
        this.workitemInfo.setWorkitemID(l2);
        this.workitemInfo.setAuditResult(Integer.valueOf(n2));
        this.workitemInfo.setUserInfo(string);
    }

    public TransferToNodeCmd(String string, Document document) {
        this.workitemInfo = new WorkitemInfo();
        this.workitemInfo.fromJSON(new JSONObject(string));
        this.document = document;
    }

    public IServiceCmd<BPMContext> newInstance() {
        return new TransferToNodeCmd();
    }

    @Override
    public void dealArguments(BPMContext object, StringHashMap<Object> stringHashMap) throws Throwable {
        object = (String)stringHashMap.get((Object)"workiteminfo");
        this.workitemInfo = new WorkitemInfo();
        this.workitemInfo.fromJSON(new JSONObject((String)object));
        if (stringHashMap.get((Object)"document") != null && ((String)stringHashMap.get((Object)"document")).length() != 0) {
            object = (String)stringHashMap.get((Object)"document");
            this.document = new Document(null, -1L);
            this.document.fromJSON(new JSONObject((String)object));
        }
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        if (this.document != null) {
            SysTopicUtil.assignSysTopic(bPMContext);
            new SaveData(this.document.getObjectKey(), null, this.document).midLaunchSave((DefaultContext)bPMContext);
        }
        bPMContext.setOperationType(2);
        Workitem workitem = this.loadWorkitem(bPMContext);
        bPMContext = BPMContext.getBPMContext(bPMContext, workitem.getInstanceID());
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, workitem.getInstanceID());
        if (bPMInstance == null) {
            return "";
        }
        if (bPMInstance.getInstanceData().getInstance().getData().getInstanceState() == 4) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)23, (Object[])new Object[0]);
        }
        bPMContext.setUpdateWorkitem(workitem);
        Object object = BPMUtil.getProcessByInstance(bPMContext, bPMInstance);
        WorkitemUtil.unlockWorkitem(bPMContext, workitem.getNodeID(), workitem.getInstanceID(), (MetaProcess)object);
        if (workitem.getTransits().size() > 0) {
            object = bPMInstance.getMainInstance().getWorkitemData().getWorkitemData(bPMContext, this.workitemInfo.getWorkitemID());
            ((RWorkitem)((Object)object)).setUserInfo(this.workitemInfo.getUserInfo());
            ((RWorkitem)((Object)object)).setAuditResult(this.workitemInfo.getAuditResult());
            if (this.workitemInfo.getSrcOperator() > 0L) {
                ((RWorkitem)((Object)object)).setOperatorID(this.workitemInfo.getSrcOperator());
            } else {
                ((RWorkitem)((Object)object)).setOperatorID(bPMContext.getCurUserID());
            }
            ((RWorkitem)((Object)object)).setFinishTime(new Timestamp(bPMContext.getDBManager().getCurTime()));
            ((RWorkitem)((Object)object)).setWorkitemState(2);
            ((RWorkitem)((Object)object)).setTransitTo(-1);
            bPMInstance.getMainInstance().getWorkitemData().deleteParticipatorData(this.workitemInfo.getWorkitemID());
            for (TransitData transitData : workitem.getTransits().values()) {
                ExecNode execNode = bPMInstance.getNodeByID(workitem.getInlineNodeID(), transitData.getNodeID());
                Object object2 = new RTransaction(workitem.getInstanceID());
                ((RTransaction)((Object)object2)).setTransactionID(bPMInstance.getInstanceData().getInstance().getData().getTransactionID());
                ((RTransaction)((Object)object2)).setWorkitemID(workitem.getWorkItemID());
                ((RTransaction)((Object)object2)).setOperatorID(bPMContext.getCurUserID());
                ((RTransaction)((Object)object2)).setworkitemRevoke(execNode.getNodeModel().isWorkitemRevoke());
                ((RTransaction)((Object)object2)).setStatusValue(StatusUtil.getStatusValue(bPMContext));
                bPMInstance.getInstanceData().getTransaction().addRow((Row)object2);
                object2 = bPMInstance.getMainInstance().getInstanceData().getToken();
                ((VTToken)((Object)object2)).deleteTokenByNodeID(workitem.getNodeID(), bPMContext.getDBManager());
                int n2 = bPMInstance.getMainInstance().applyNewTokenID();
                ((VTToken)((Object)object2)).createNewToken(n2, workitem.getNodeID());
                bPMContext.setActiveTokenID(n2);
                bPMInstance.getMainInstance().getInstanceData().getNode().getNodeData(transitData.getNodeID(), bPMContext.getDBManager()).setWorkitemID(-1L);
                bPMContext.setActiveNode(execNode);
                bPMContext.setTransitData(transitData);
                transitData.setKeepParts(this.workitemInfo.getKeepParts());
                execNode.input(bPMContext);
            }
        } else {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)28, (Object[])new Object[0]);
        }
        bPMInstance.getInstanceData().getTransitTo().deleteRows(this.workitemInfo.getWorkitemID(), bPMContext.getDBManager());
        bPMContext.getInstanceDataContainer().save();
        return null;
    }

    @Override
    public String getCmd() {
        return TAG;
    }

    private Workitem loadWorkitem(BPMContext object) throws Throwable {
        if ((object = WorkitemUtil.loadWorkitem((DefaultContext)object, this.workitemInfo.getWorkitemID())) == null) {
            return null;
        }
        ((Workitem)object).setAuditResult(this.workitemInfo.getAuditResult());
        ((Workitem)object).setUserInfo(this.workitemInfo.getUserInfo());
        ((Workitem)object).setResultInfo(Result.parseToString(this.workitemInfo.getAuditResult()));
        ((Workitem)object).setOperationKey(this.workitemInfo.getOperationKey());
        ((Workitem)object).setNextOpStr(this.workitemInfo.getNextOpStr());
        return object;
    }
}

