/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.predict;

import com.bokesoft.yes.bpm.model.BPMNodeModel;
import com.bokesoft.yes.bpm.model.BPMProcessModel;
import com.bokesoft.yes.bpm.predict.BPMPredictContext;
import com.bokesoft.yes.bpm.predict.BPMPredictResult;
import com.bokesoft.yes.bpm.predict.handler.BPMNodePredictHandlerFactory;
import com.bokesoft.yes.bpm.predict.handler.IBPMNodePredictHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class BPMPredictInstance {
    private final BPMProcessModel model;
    private final Integer lastNodeID;
    private boolean withFacts;

    public BPMPredictInstance(BPMProcessModel bPMProcessModel, Integer n2) {
        this.model = bPMProcessModel;
        this.lastNodeID = n2 == null ? bPMProcessModel.getBeginNodeID() : n2.intValue();
    }

    public BPMProcessModel getModel() {
        return this.model;
    }

    public boolean isWithFacts() {
        return this.withFacts;
    }

    public void setWithFacts(boolean bl) {
        this.withFacts = bl;
    }

    public BPMPredictResult run(BPMPredictContext bPMPredictContext) throws Throwable {
        BPMPredictResult bPMPredictResult = new BPMPredictResult();
        BPMNodeModel bPMNodeModel = this.model.getNode(this.lastNodeID.intValue());
        if (bPMNodeModel != null) {
            this.runNode(bPMPredictContext, bPMNodeModel, bPMPredictResult);
        }
        return bPMPredictResult;
    }

    private void runNode(BPMPredictContext bPMPredictContext, BPMNodeModel bPMNodeModel, BPMPredictResult bPMPredictResult) throws Throwable {
        List<IBPMNodePredictHandler> list = BPMNodePredictHandlerFactory.getInstance().create(bPMPredictContext, this, bPMNodeModel);
        if (list != null && !list.isEmpty()) {
            List<Integer> list2;
            int n2 = bPMNodeModel.getID();
            Iterator<IBPMNodePredictHandler> iterator = list.iterator();
            while (iterator.hasNext()) {
                list2 = iterator.next().getParticipatorIDs(bPMPredictContext);
                if (list2 == null) continue;
                bPMPredictResult.getParticatorIDMap().put(n2, new LinkedHashSet(list2));
                break;
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                list2 = iterator.next().checkJoin(bPMPredictContext);
                if (list2 == null) continue;
                if (((Boolean)((Object)list2)).booleanValue()) {
                    bPMPredictContext.addJoinSuccess(n2);
                    break;
                }
                if (!bPMPredictContext.isJoinSuccess(n2)) {
                    bPMPredictResult.getLastNodeIDs().add(n2);
                }
                return;
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                list2 = iterator.next().getNextNodeIDs(bPMPredictContext);
                if (list2 == null) continue;
                this.runNextNodes(bPMPredictContext, n2, bPMPredictResult, list2);
                return;
            }
        }
        List list3 = bPMNodeModel.getNextNodeIDs();
        this.runNextNodes(bPMPredictContext, bPMNodeModel.getID(), bPMPredictResult, list3);
    }

    private void runNextNodes(BPMPredictContext bPMPredictContext, int n2, BPMPredictResult bPMPredictResult, List<Integer> bPMNodeModel) throws Throwable {
        if (bPMNodeModel == null || bPMNodeModel.isEmpty()) {
            bPMPredictResult.getLastNodeIDs().add(n2);
            return;
        }
        bPMPredictResult.getLastNodeIDs().remove(n2);
        bPMPredictResult.getPastPathMap().put(n2, new ArrayList<Integer>((Collection<Integer>)bPMNodeModel));
        for (int n3 : bPMNodeModel) {
            bPMNodeModel = this.model.getNode(n3);
            if (bPMNodeModel == null) continue;
            this.runNode(bPMPredictContext, bPMNodeModel, bPMPredictResult);
        }
    }
}

