package com.bokesoft.yigo.bpm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 查询流程实例标识（InstanceID）
 * 
 * @author zhanght
 *
 */
public class QueryInstanceID {

	private Document doc;
	
	/**
	 * 使用Document对象作为参数构建流程实例标识查询类
	 * @param doc
	 */
	public QueryInstanceID(Document doc) {
		this.doc = doc;
	}
	
	/**
	 * 查询与指定的Document对象绑定的流程实例标识，如果不存在则返回-1
	 * @param context
	 * @return
	 * @throws Throwable
	 */
	public long query(DefaultContext context) throws Throwable{
		long instanceID = -1l;
		IDBManager DBManager = context.getDBManager();
		String sql = "select " 
					+ DBManager.keyWordEscape(SystemDBField.INSTANCEID)
					+ " from " 
					+ DBManager.keyWordEscape(SystemDBField.BPM_INSTANCE) 
					+ " where " 
					+ DBManager.keyWordEscape(SystemDBField.OID) + "=?";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try{
			ps = context.getDBManager().preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addLongArg(doc.getOID());
			rs = context.getDBManager().executeQuery(ps, sql, args);
			if (rs.next()) {
				instanceID = rs.getLong(1);
			}
		} finally {
			if (ps != null) {
				ps.close();
			}
			if (rs != null) {
				rs.close();
			}
		}
		return instanceID;
	}
}
