package com.bokesoft.yigo.bpm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.json.JSONObject;

import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;

/**
 * 加载数据库流程
 * 
 * @author guowj
 *
 */
public class LoadDBProcess {
	
	public JSONObject load(DefaultContext context, String processKey, int version) throws Throwable{
		JSONObject processJson = null;
		if(version == -1){
			processJson = getProcessByDeployKey(context, processKey);
		}else{
			processJson = getProcess(context, processKey, version);
		}
		return processJson;
	}
	
	/**
	 * 加载指定版本的流程
	 * 
	 * @param context
	 * @param processKey
	 * @param version
	 * @return
	 * @throws Throwable
	 */
	private JSONObject getProcess(DefaultContext context, String processKey, int version) throws Throwable{
		JSONObject processJson = null;
		IDBManager DBManager = context.getDBManager();
		String sql = "select "
				+ DBManager.keyWordEscape(SystemDBField.DEFINATION)
				+ " from " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
				+ " where "
				+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + " = ? and "
				+ DBManager.keyWordEscape(SystemDBField.WF_VERID) + " = ?";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = DBManager.preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addStringArg(processKey);
			args.addIntArg(version);
			rs = DBManager.executeQuery(ps, sql, args);
			if(rs.next()){
				String defination = rs.getString(1);
				if(defination != null && defination.length() > 0){
					processJson = new JSONObject(defination);
				}
			}
		
		} finally {
			if (ps != null)
				ps.close();
			if (rs != null)
				rs.close();
		}
		return processJson;
	}
	
	/**
	 * 加载已部署版本的流程
	 * 
	 * @param context
	 * @param processKey
	 * @return
	 * @throws Throwable
	 */
	private JSONObject getProcessByDeployKey(DefaultContext context, String processKey) throws Throwable{
		JSONObject processJson = null;
		IDBManager DBManager = context.getDBManager();
		String sql = "select "
				+ DBManager.keyWordEscape(SystemDBField.DEFINATION) 
				+ " from " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
				+ " where "
				+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + " = ? and "
				+ DBManager.keyWordEscape(SystemDBField.ALREADYDEPLOY) + " = ?";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = DBManager.preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addStringArg(processKey);
			args.addIntArg(1);
			rs = DBManager.executeQuery(ps, sql, args);
			if(rs.next()){
				String defination = rs.getString(1);
				if(defination != null && defination.length() > 0){
					processJson = new JSONObject(defination);
				}
			}
		
		} finally {
			if (ps != null)
				ps.close();
			if (rs != null)
				rs.close();
		}
		return processJson;
	}
}
