/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.engine.data.row.REventLog;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.sql.Timestamp;

public class PauseInstanceCmd
extends BPMServiceCmd {
    public static final String TAG = "PauseInstance";
    private Long instanceID;
    private String userinfo = "";

    public PauseInstanceCmd() {
    }

    public PauseInstanceCmd(Long l2) {
        this.instanceID = l2;
    }

    public IServiceCmd<BPMContext> newInstance() {
        return new PauseInstanceCmd();
    }

    @Override
    public void dealArguments(BPMContext bPMContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.instanceID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"instanceID"));
        this.userinfo = TypeConvertor.toString((Object)stringHashMap.get((Object)"userInfo"));
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        bPMContext = BPMContext.getBPMContext(bPMContext, this.instanceID);
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, this.instanceID);
        REventLog rEventLog = new REventLog(this.instanceID);
        rEventLog.setLogID(bPMInstance.getInstanceData().getInstance().applyNewEventID());
        rEventLog.setEventTime(new Timestamp(bPMContext.getDBManager().getCurTime()));
        rEventLog.setActiveType(0);
        rEventLog.setName("\u6682\u505c");
        rEventLog.setsOperator(bPMContext.getVE().getEnv().getUserID());
        rEventLog.setUserinfo(this.userinfo);
        rEventLog.settOperator(-1L);
        bPMInstance.getInstanceData().getEventLog().addRow(rEventLog);
        bPMInstance.pauseInstance(bPMContext);
        bPMContext.getInstanceDataContainer().save();
        return Boolean.TRUE;
    }

    @Override
    public String getCmd() {
        return TAG;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public void setUserinfo(String string) {
        this.userinfo = string;
    }
}

