/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.node;

import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.data.row.RLog;
import com.bokesoft.yes.bpm.engine.data.row.RNode;
import com.bokesoft.yes.bpm.engine.data.virtual.VirtualInstanceData;
import com.bokesoft.yes.bpm.engine.instance.CreateNodeUtil;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.interpreter.NodeFactoryProxy;
import com.bokesoft.yes.bpm.interpreter.defaultproxy.DefaultProxy;
import com.bokesoft.yes.bpm.util.QuerySqlUtil;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.gop.bpm.IExecutionContext;
import com.bokesoft.yes.gop.bpm.handler.IInlineHandler;
import com.bokesoft.yes.mid.cache.Row;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaBasicParameter;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaBasicParameterCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaMidFormulaParameter;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaParameterCollections;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaSqlQueryParameter;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaStaticParameter;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaStaticParameterCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.Timestamp;
import java.util.List;

public class ExecInline
extends ExecNode
implements IInlineHandler {
    private MetaInline inline = null;
    private VirtualInstance inlineInstance = null;

    public ExecInline(VirtualInstance virtualInstance, MetaNode metaNode) {
        super(virtualInstance, metaNode);
        this.inline = (MetaInline)metaNode;
    }

    public void visit(IExecutionContext iExecutionContext) throws Throwable {
        if (!this.checkPreCondition(iExecutionContext)) {
            this.cleanContext(iExecutionContext);
            this.cleanInlineNodeContext(iExecutionContext);
            this.leave(iExecutionContext);
            return;
        }
        this.preVist(iExecutionContext);
        this.removeToken(iExecutionContext);
        this.addLogIfNecessary(iExecutionContext);
        BPMContext bPMContext = (BPMContext)iExecutionContext;
        Object object = this.inline.getInlinePara();
        if (object != null && object.size() > 0) {
            bPMContext.ensureParas();
            object = object.iterator();
            while (object.hasNext()) {
                MetaBasicParameterCollection metaBasicParameterCollection = (MetaBasicParameterCollection)object.next();
                if (metaBasicParameterCollection.getTagName().equals("StaticParameterCollection")) {
                    bPMContext.getParas().put("inlinePara", (Object)metaBasicParameterCollection.toJSON().toString());
                    this.handleAndStart(iExecutionContext);
                    continue;
                }
                if (!metaBasicParameterCollection.getTagName().equals("DynamicParameterCollection")) continue;
                this.processDynamicParameter(bPMContext, metaBasicParameterCollection);
            }
            return;
        }
        this.handleAndStart(iExecutionContext);
    }

    private void processDynamicParameter(BPMContext bPMContext, MetaBasicParameterCollection object) throws Throwable {
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            MetaBasicParameterCollection metaBasicParameterCollection2;
            Object object2 = (MetaBasicParameter)object.next();
            if (object2.getTagName().equals("SqlQueryParameter")) {
                for (MetaBasicParameterCollection metaBasicParameterCollection2 : QuerySqlUtil.ExecSql(bPMContext, (MetaSqlQueryParameter)object2, MetaParameterCollections.class)) {
                    bPMContext.getParas().put("inlinePara", (Object)metaBasicParameterCollection2.toJSON().toString());
                    this.handleAndStart(bPMContext);
                    ++n2;
                }
                continue;
            }
            if (!object2.getTagName().equals("MidFormulaParameter") || (object2 = bPMContext.getMidParser().eval(0, ((MetaMidFormulaParameter)object2).getFormula())) == null || !(object2 instanceof DataTable)) continue;
            metaBasicParameterCollection2 = (DataTable)object2;
            object2 = metaBasicParameterCollection2.getMetaData();
            int n3 = object2.getColumnCount();
            metaBasicParameterCollection2.beforeFirst();
            while (metaBasicParameterCollection2.next()) {
                MetaStaticParameterCollection metaStaticParameterCollection = new MetaStaticParameterCollection();
                for (int i2 = 0; i2 < n3; ++i2) {
                    MetaStaticParameter metaStaticParameter = new MetaStaticParameter();
                    ColumnInfo columnInfo = object2.getColumnInfo(i2);
                    metaStaticParameter.setFieldKey(columnInfo.getColumnKey());
                    metaStaticParameter.setFormula(metaBasicParameterCollection2.getObject(columnInfo.getColumnKey()).toString());
                    metaStaticParameter.setDataType(columnInfo.getDataType());
                    metaStaticParameterCollection.add((AbstractMetaObject)metaStaticParameter);
                }
                bPMContext.getParas().put("inlinePara", (Object)metaStaticParameterCollection.toJSON().toString());
                this.handleAndStart(bPMContext);
                ++n2;
            }
        }
        if (n2 == 0) {
            this.handleAndStart(bPMContext);
        }
    }

    private void handleAndStart(IExecutionContext iExecutionContext) throws Throwable {
        this.handleInlineNode(iExecutionContext);
        if (this.checkStraightEmbedNodeID(iExecutionContext)) {
            this.straightEmbedNode(iExecutionContext);
            return;
        }
        this.startInlineInstance(iExecutionContext);
    }

    public VirtualInstance initInlineInstance(NodeFactoryProxy nodeFactoryProxy, BPMContext bPMContext) throws Throwable {
        MetaProcess metaProcess;
        int n2 = this.node.getID();
        Object object = this.instance.getInstanceData().getNode().getNodeData(n2, bPMContext.getDBManager());
        int n3 = ((RNode)object).getInlineVersion();
        bPMContext.setInlineNode(this);
        String string = BPMUtil.getInlineProcessKey(this.inline, (DefaultContext)bPMContext, (RNode)object);
        if (string == null || string.length() == 0) {
            return null;
        }
        ((RNode)object).setInlineProcessKey(string);
        if (n3 > 0) {
            metaProcess = BPMUtil.getProcessDefinationBy(bPMContext.getVE(), string, n3);
        } else {
            metaProcess = BPMUtil.getProcessDefinationByDeployKey(bPMContext.getVE(), string);
            ((RNode)object).setInlineVersion(metaProcess.getVersion());
        }
        object = this.instance.getBPMInstance().getInstanceData().createVirtualInstanceData(this.getID());
        this.inlineInstance = new VirtualInstance(metaProcess, nodeFactoryProxy, (VirtualInstanceData)object, this.instance.getBPMInstance(), bPMContext);
        this.inlineInstance.setInlineNode(this);
        return this.inlineInstance;
    }

    public void embedInstanceEnd(BPMContext bPMContext) throws Throwable {
        boolean bl = true;
        if (null != bPMContext.getPara("inlinePara")) {
            bPMContext.getParas().remove("inlinePara");
            List<Workitem> list = WorkitemUtil.getWorkitemsByInstanceID(bPMContext.getDBManager(), this.instance.getInstanceID());
            if (list != null && list.size() > 1) {
                bl = false;
            }
        }
        if (bl) {
            int n2 = this.instance.applyNewTokenID();
            this.instance.getInstanceData().getToken().createNewToken(n2, this.getID());
            bPMContext.setActiveTokenID(n2);
            this.output(bPMContext);
        }
    }

    public void startInlineInstance(IExecutionContext iExecutionContext) throws Throwable {
        this.inlineInstance.startInstance((BPMContext)iExecutionContext);
    }

    public boolean checkStraightEmbedNodeID(IExecutionContext iExecutionContext) throws Throwable {
        return ((BPMContext)iExecutionContext).getStraightEmbedNodeID() > 0;
    }

    public void straightEmbedNode(IExecutionContext iExecutionContext) throws Throwable {
        ExecNode execNode;
        int n2 = this.inlineInstance.applyNewTokenID();
        this.inlineInstance.getInstanceData().getToken().createNewToken(n2, -1);
        iExecutionContext.setActiveTokenID(n2);
        n2 = ((BPMContext)iExecutionContext).getStraightEmbedNodeID();
        try {
            execNode = this.inlineInstance.getNodeByID(n2);
        }
        catch (Throwable throwable) {
            execNode = this.createNode(iExecutionContext);
        }
        execNode.input(iExecutionContext);
    }

    private ExecNode createNode(IExecutionContext iExecutionContext) throws Throwable {
        MetaNode metaNode = this.inlineInstance.getMetaNodeByID(((BPMContext)iExecutionContext).getStraightEmbedNodeID());
        return new CreateNodeUtil(iExecutionContext, this.inlineInstance).createNode(metaNode);
    }

    public void handleInlineNode(IExecutionContext iExecutionContext) throws Throwable {
        VirtualInstance virtualInstance = this.initInlineInstance(new DefaultProxy(), (BPMContext)iExecutionContext);
        virtualInstance.checkAndCreateNodeData(iExecutionContext.getDBManager());
        this.instance.getBPMInstance().putInstanceMap(this.inline.getID(), virtualInstance);
    }

    public VirtualInstance getInlineVirtualInstance() {
        return this.inlineInstance;
    }

    public void cleanInlineNodeContext(IExecutionContext iExecutionContext) throws Throwable {
        ((BPMContext)iExecutionContext).setInlineNode(null);
    }

    public void addLogIfNecessary(IExecutionContext object) throws Throwable {
        BPMContext bPMContext = (BPMContext)((Object)object);
        long l2 = -3L;
        while (this.getVirtualInstance().getBPMInstance().getInstanceData().getLog().getLogByWID(l2, object.getDBManager()) != null) {
            --l2;
        }
        Timestamp timestamp = new Timestamp(bPMContext.getDBManager().getCurTime());
        object = new RLog(this.getInstanceID());
        ((RLog)object).setLogID(this.getVirtualInstance().applyNewLogID());
        ((RLog)object).setInlineNodeID(this.instance.getInstanceData().getInlineNodeID());
        ((RLog)object).setCreateTime(timestamp);
        ((RLog)object).setLogIndex(this.getVirtualInstance().applyNewLogIndexID());
        ((RLog)object).setNodeID(this.getID());
        ((RLog)object).setAuditResult(1);
        ((RLog)object).setFinishTime(timestamp);
        ((RLog)object).setOperatorID(bPMContext.getCurUserID());
        ((RLog)object).setWorkitemName(this.getNodeModel().getCaption());
        ((RLog)object).setWorkitemState(2);
        ((RLog)object).setWorkitemID(l2);
        this.getVirtualInstance().getBPMInstance().getInstanceData().getLog().addRow((Row)object);
    }
}

