/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.common;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.data.row.RLog;
import com.bokesoft.yes.bpm.engine.data.row.RNode;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.i18n.StringTable;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.tools.dic.DictCacheUtil;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.bpm.dev.IBPMNodeAction;
import com.bokesoft.yigo.bpm.dev.IDelegateCheck;
import com.bokesoft.yigo.bpm.dev.IWorkflowHook;
import com.bokesoft.yigo.bpm.dev.Template;
import com.bokesoft.yigo.bpm.intl.IBPMGraphInfo;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.tools.ve.VE;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

public class BPMUtil {
    public static MetaProcess getProcessDefinationByMetaKey(BPMContext bPMContext, String string, String string2) throws Throwable {
        MetaProcessMap metaProcessMap = BPMUtil.getMapInfoByMetaKey(bPMContext, string, string2);
        if (metaProcessMap != null) {
            MetaProcess metaProcess = BPMUtil.getProcessDefinationByMapInfo(bPMContext, metaProcessMap);
            if (metaProcess == null && !metaProcessMap.isDynamicBinding().booleanValue()) {
                throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)9, (Object[])new Object[]{string2, string});
            }
            return metaProcess;
        }
        throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)9, (Object[])new Object[]{string2, string});
    }

    public static String getProcessVersionKeyByMetaKey(BPMContext object, String string, String string2, MetaBPM metaBPM) throws Throwable {
        String string3 = null;
        if ((string = BPMUtil.getMapInfoByMetaKey((DefaultContext)object, string, string2, metaBPM)) != null) {
            string2 = string.getProcessKey();
            if (string.isDynamicBinding().booleanValue()) {
                if ((object = object.getMidParser().eval(0, string.getProcessKeyFormula())) == null) {
                    return null;
                }
                string2 = object.toString();
            }
            if ((object = (MetaProcessDeployInfo)metaBPM.getMetaBPMDeployInfoCollection().get(string2)) == null) {
                return null;
            }
            string3 = object.getKey() + "_V" + object.getVersion();
        }
        return string3;
    }

    public static MetaProcessMap getMapInfoByMetaKey(DefaultContext defaultContext, String string, String string2) throws Throwable {
        return BPMUtil.getMapInfoByMetaKey(defaultContext, string, string2, null);
    }

    public static MetaProcessMap getMapInfoByMetaKey(DefaultContext defaultContext, String string, String string2, MetaBPM metaBPM) throws Throwable {
        Template template;
        MetaForm metaForm;
        IMetaFactory iMetaFactory = defaultContext.getVE().getMetaFactory();
        if (string2 != null && string2.length() > 0 && (metaForm = iMetaFactory.getMetaForm(string2)) != null) {
            string2 = metaForm.getMainFormKey();
        }
        metaForm = null;
        if (metaBPM == null) {
            metaBPM = iMetaFactory.getMetaBPM();
        }
        if ((template = BPMUtil.getTemplate(defaultContext.getVE())) != null) {
            metaForm = template.getMapInfoByMetaKey(defaultContext, string, string2);
        }
        if (metaForm == null) {
            metaForm = metaBPM.getMetaProcessMapCollection().getFormMapInfo(string2);
        } else {
            new MetaDataObject();
            if (metaForm.getType() == 2) {
                iMetaFactory.getDataObject(metaForm.getKey());
            } else if (metaForm.getType() == 1 && (defaultContext = iMetaFactory.getMetaForm(metaForm.getKey())) != null && defaultContext.getDataSource().getDataObject() != null) {
                defaultContext.getDataSource().getDataObject();
            }
        }
        if (metaForm == null) {
            metaForm = metaBPM.getMetaProcessMapCollection().getDataobjectMapInfo(string);
        }
        return metaForm;
    }

    public static MetaProcess getProcessDefinationByMapInfo(DefaultContext defaultContext, MetaProcessMap metaProcessMap) throws Throwable {
        Object object;
        String string = metaProcessMap.getProcessKey();
        if (metaProcessMap.isDynamicBinding().booleanValue()) {
            object = defaultContext.getMidParser().eval(0, metaProcessMap.getProcessKeyFormula());
            if (object == null) {
                return null;
            }
            string = object.toString();
            if (string.isEmpty()) {
                return null;
            }
        }
        if ((object = defaultContext.getVE().getMetaFactory().getProcessDefinationByDeployKey(string)) != null) {
            return object;
        }
        if (metaProcessMap.isDynamicBinding().booleanValue()) {
            throw BPMError.getBPMError((ILocale)defaultContext.getEnv(), (int)10, (Object[])new Object[]{string});
        }
        return object;
    }

    public static MetaProcess getProcessDefinationByDeployKey(MidVE midVE, String string) throws Throwable {
        MetaProcess metaProcess = midVE.getMetaFactory().getProcessDefinationByDeployKey(string);
        if (metaProcess != null) {
            return metaProcess;
        }
        throw BPMError.getBPMError((ILocale)midVE.getEnv(), (int)8, (Object[])new Object[]{string});
    }

    public static MetaProcess getProcessDefinationBy(MidVE midVE, String string, int n2) throws Throwable {
        MetaProcess metaProcess = n2 == -1 ? BPMUtil.getProcessDefinationByDeployKey(midVE, string) : midVE.getMetaFactory().getProcessDefinationBy(string, n2);
        if (metaProcess != null) {
            return metaProcess;
        }
        throw BPMError.getBPMError((ILocale)midVE.getEnv(), (int)11, (Object[])new Object[]{string, n2});
    }

    public static MetaProcess getProcessByInstance(DefaultContext defaultContext, BPMInstance object) throws Throwable {
        if (object == null) {
            return null;
        }
        String string = ((BPMInstance)object).getInstanceData().getInstance().getData().getProcessKey();
        object = ((BPMInstance)object).getInstanceData().getInstance().getData().getVerID();
        return BPMUtil.getProcessDefinationBy(defaultContext.getVE(), string, (Integer)object);
    }

    public static MetaDataObject getDataMigrationMetaDataObject(MidVE midVE) throws Throwable {
        return midVE.getMetaFactory().getDataObject("BPM_Migration");
    }

    public static MetaNode getNode(MidVE midVE, MetaProcess metaProcess, int n2) {
        MetaNode metaNode = metaProcess.getNodeByID(n2);
        if (metaNode == null) {
            throw BPMError.getBPMError((ILocale)midVE.getEnv(), (int)15, (Object[])new Object[]{n2, metaProcess.getKey()});
        }
        return metaNode;
    }

    public static Template getTemplate(MidVE midVE) throws Throwable {
        Object object = midVE.getMetaFactory().getSetting();
        if (object == null) {
            return null;
        }
        if ((object = object.getBPMSetting()) == null) {
            return null;
        }
        if ((object = object.getBPMTemplatePath()) == null || ((String)object).length() == 0) {
            return null;
        }
        return (Template)ReflectHelper.newInstance((VE)midVE, (String)object);
    }

    public static IWorkflowHook getWorkFlowHook(MidVE midVE, String string) throws Throwable {
        if (string == null || string.length() <= 0) {
            string = midVE.getMetaFactory().getSetting();
            if (string == null) {
                return null;
            }
            if ((string = string.getBPMSetting()) == null) {
                return null;
            }
            string = string.getWorkFlowHookPath();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return (IWorkflowHook)ReflectHelper.newInstance((VE)midVE, (String)string);
    }

    public static IBPMGraphInfo getBPMGraphInfo(MidVE midVE, String string) throws Throwable {
        if (string == null || string.length() <= 0) {
            string = midVE.getMetaFactory().getSetting();
            if (string == null) {
                return null;
            }
            if ((string = string.getBPMSetting()) == null) {
                return null;
            }
            string = string.getBPMGraphInfoPath();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return (IBPMGraphInfo)ReflectHelper.newInstance((VE)midVE, (String)string);
    }

    public static IBPMNodeAction getBPMNodeAction(MidVE midVE, String string) throws Throwable {
        if (string == null || string.length() <= 0) {
            string = midVE.getMetaFactory().getSetting();
            if (string == null) {
                return null;
            }
            if ((string = string.getBPMSetting()) == null) {
                return null;
            }
            string = string.getBPMNodeAction();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return (IBPMNodeAction)ReflectHelper.newInstance((VE)midVE, (String)string);
    }

    public static IDelegateCheck getDelegateCheck(MidVE midVE, String string) throws Throwable {
        if (string == null || string.length() <= 0) {
            string = midVE.getMetaFactory().getSetting();
            if (string == null) {
                return null;
            }
            if ((string = string.getBPMSetting()) == null) {
                return null;
            }
            string = string.getDelegateCheck();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return (IDelegateCheck)ReflectHelper.newInstance((VE)midVE, (String)string);
    }

    public static RLog addDelegateLog(BPMContext object, RWorkitem rWorkitem, long l2, long l3, String string) throws Throwable {
        BPMInstance bPMInstance = object.getActiveBPMInstance();
        RLog rLog = new RLog(bPMInstance.getInstanceID());
        int n2 = bPMInstance.getInstanceData().getInstance().applyNewLogID();
        int n3 = bPMInstance.getInstanceData().getInstance().applyNewLogIndexID();
        rLog.setLogID(n2);
        rLog.setLogIndex(n3);
        rLog.setCreateTime(new Timestamp(new Date().getTime()));
        rLog.setFinishTime(new Timestamp(new Date().getTime()));
        rLog.setWorkitemID(-2L);
        rLog.setWorkitemName(rWorkitem.getWorkItemName());
        rLog.setWorkitemState(2);
        rLog.setNodeID(rWorkitem.getNodeID());
        rLog.setOperatorID(l2);
        object = BPMUtil.defaultUserInfo(object, rWorkitem.getWorkItemID(), l2, l3);
        if (string != null && !string.isEmpty()) {
            object = string;
        }
        rLog.setUserInfo((String)object);
        return rLog;
    }

    private static String defaultUserInfo(BPMContext bPMContext, long l2, long l3, long l4) throws Throwable {
        String string = TypeConvertor.toString((Object)DictCacheUtil.getDictValue((VE)bPMContext.getVE(), (IDictCacheProxy)bPMContext.getDictCache(), (String)"Operator", (long)l3, (String)"Name"));
        String string2 = TypeConvertor.toString((Object)DictCacheUtil.getDictValue((VE)bPMContext.getVE(), (IDictCacheProxy)bPMContext.getDictCache(), (String)"Operator", (long)l4, (String)"Name"));
        return BPMError.formatMessage((ILocale)bPMContext.getEnv(), (int)36, (Object[])new Object[]{string, l2, string2});
    }

    public static void syncDataForReceiveMessage(BPMContext bPMContext, VirtualInstance virtualInstance, MetaNode metaNode, int n2) throws Throwable {
        Object object = virtualInstance.getInstanceData().getNode().getNodeData(metaNode.getID(), bPMContext.getDBManager()).getWorkitemID();
        object = virtualInstance.getWorkitemData().getWorkitemData(bPMContext, (Long)object);
        ((RWorkitem)((Object)object)).setAuditResult(n2);
        ((RWorkitem)((Object)object)).setUserInfo(StringTable.getString((ILocale)bPMContext.getEnv(), (String)"", (String)"DefaultMessageUserInfo"));
        virtualInstance.getInstanceData().getNode().getNodeData(metaNode.getID(), bPMContext.getDBManager()).setResult(n2);
        virtualInstance.createLogForWorkitem((RWorkitem)((Object)object), bPMContext.getDBManager());
    }

    public static String getInlineProcessKey(MetaInline metaInline, DefaultContext defaultContext, RNode rNode) throws Throwable {
        return BPMUtil.getInlineProcessKey(metaInline, defaultContext, rNode, -1L);
    }

    public static String getInlineProcessKey(MetaInline metaInline, DefaultContext defaultContext, Long l2) throws Throwable {
        return BPMUtil.getInlineProcessKey(metaInline, defaultContext, null, l2);
    }

    public static String getInlineProcessKey(MetaInline metaInline, DefaultContext defaultContext, RNode object, Long l2) throws Throwable {
        String string = metaInline.getInlineProcessKey();
        if (string == null || string.length() == 0) {
            if (object != null) {
                string = ((RNode)object).getInlineProcessKey();
            } else {
                object = null;
                ResultSet resultSet = null;
                try {
                    IDBManager iDBManager = defaultContext.getDBManager();
                    String string2 = "select " + iDBManager.keyWordEscape("InlineProcessKey") + " from " + iDBManager.keyWordEscape("BPM_Node") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("InlineNodeID") + "=? and " + iDBManager.keyWordEscape("NodeID") + "=?";
                    object = iDBManager.preparedQueryStatement(string2);
                    PSArgs pSArgs = new PSArgs();
                    pSArgs.addLongArg(l2);
                    pSArgs.addIntArg(Integer.valueOf(-1));
                    pSArgs.addIntArg(metaInline.getID());
                    resultSet = iDBManager.executeQuery((PreparedStatement)object, string2, (QueryArguments)pSArgs);
                    if (resultSet.next()) {
                        string = resultSet.getString(1);
                        resultSet.close();
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (object != null) {
                        object.close();
                    }
                }
            }
        }
        if ((string == null || string.length() == 0) && (object = metaInline.getProcessKeyFormula()) != null && ((String)object).length() > 0) {
            string = defaultContext.getMidParser().eval(0, (String)object).toString();
        }
        return string;
    }

    public static MetaProcess getInlineProcess(MetaInline metaInline, DefaultContext defaultContext, Long l2) throws Throwable {
        Object object;
        Integer n2 = -1;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            object = defaultContext.getDBManager();
            String string = "select " + object.keyWordEscape("InlineVersion") + " from " + object.keyWordEscape("BPM_Node") + " where " + object.keyWordEscape("InstanceID") + "=? and " + object.keyWordEscape("InlineNodeID") + "=? and " + object.keyWordEscape("NodeID") + "=?";
            statement = object.preparedQueryStatement(string);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addLongArg(l2);
            pSArgs.addIntArg(Integer.valueOf(-1));
            pSArgs.addIntArg(metaInline.getID());
            resultSet = object.executeQuery((PreparedStatement)statement, string, (QueryArguments)pSArgs);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
                resultSet.close();
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        object = BPMUtil.getInlineProcessKey(metaInline, defaultContext, null, l2);
        metaInline = n2 == null || n2 == -1 ? defaultContext.getVE().getMetaFactory().getProcessDefinationByDeployKey((String)object) : defaultContext.getVE().getMetaFactory().getProcessDefinationBy((String)object, n2.intValue());
        return metaInline;
    }

    public static boolean checkBPMProcess(DefaultContext defaultContext) throws Throwable {
        Object object = defaultContext.getDocument();
        if (object == null) {
            return false;
        }
        String string = defaultContext.getFormKey();
        return BPMUtil.getMapInfoByMetaKey(defaultContext, (String)(object = object.getMetaDataObject().getKey()), string) != null;
    }
}

