package com.bokesoft.yigo.bpm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.meta.transform.InstanceState;
import com.bokesoft.yes.bpm.service.cmd.RevokeWorkitemCmd;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.DBType;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.document.Document;

public class RevokeWorkitem {

	private String userInfo = "";
	
	public RevokeWorkitem() {
		// TODO Auto-generated constructor stub
	}
	
	public RevokeWorkitem(String userInfo) {
		this.userInfo = userInfo;
	}
	
	public void setUserInfo(String userInfo) {
		this.userInfo = userInfo;
	}
	
	public String getUserInfo() {
		return userInfo;
	}
	
	public void revokeWorkitem(DefaultContext context) throws Throwable {
		Document doc = context.getDocument();
		if (doc == null) {
			return;
		}
		MetaTable mainTable = doc.getMetaDataObject().getMainTable();
		if (mainTable == null)
			return;
		MetaColumn ic = mainTable.getINSTANCEIDColumn();
		Long instanceID = -1L;
		Integer instanceState = -1;
		String processKey = "";
		Integer verID = -1;
		IDBManager dbManager = context.getDBManager();
		// 存在INSTANCEID系统字段的情况
		if (ic != null) {
			instanceID = (Long) doc.get(mainTable.getKey()).getObject(0, ic.getKey());
			if (instanceID == null)
				instanceID = -1L;
			if (instanceID > 0) {
				PreparedStatement ps = null;
				ResultSet rs = null;
				try {
					String sql = "select " 
							+ dbManager.keyWordEscape(SystemDBField.INSTANCESTATE) + ", "
							+ dbManager.keyWordEscape(SystemDBField.PROCESSKEY) + ", "
							+ dbManager.keyWordEscape(SystemDBField.WF_VERID) 
							+ " from "
							+ dbManager.keyWordEscape(SystemDBField.BPM_INSTANCE) 
							+ " where " 
							+ dbManager.keyWordEscape(SystemDBField.INSTANCEID) + "=?";
					ps = context.getDBManager().preparedQueryStatement(sql);
					ps.setLong(1, instanceID);
					rs = ps.executeQuery();
					if (rs.next()) {
						instanceState = rs.getInt(1);
						if (instanceState == InstanceState.END || instanceState == InstanceState.KILLED || instanceState == InstanceState.PAUSE){
							return;
						}
						processKey = rs.getString(2);
						verID = rs.getInt(3);
					}
				} finally {
					if (rs != null)
						rs.close();
					if (ps != null)
						ps.close();
				}
			}
		}
		if (instanceID < 0) {
			PreparedStatement ps = null;
			ResultSet rs = null;
			try {
				String sql = "select " 
					    + dbManager.keyWordEscape(SystemDBField.INSTANCESTATE) + ", "
					    + dbManager.keyWordEscape(SystemDBField.PROCESSKEY) + ", "
					    + dbManager.keyWordEscape(SystemDBField.WF_VERID) + ", "
					    + dbManager.keyWordEscape(SystemDBField.INSTANCEID) 
					    + " from "
		            	+ dbManager.keyWordEscape(SystemDBField.BPM_INSTANCE) 
		            	+ " where " 
		            	+ dbManager.keyWordEscape(SystemDBField.OID) + "=?";
				ps = context.getDBManager().preparedQueryStatement(sql);
				ps.setLong(1, doc.getOID());
				rs = ps.executeQuery();
				if (rs.next()) {
					instanceState = rs.getInt(1);
					if (instanceState == InstanceState.END || instanceState == InstanceState.KILLED || instanceState == InstanceState.PAUSE){
						return;
					}
					processKey = rs.getString(2);
					verID = rs.getInt(3);
					instanceID = rs.getLong(4);
				}
			} finally {
				if (rs != null)
					rs.close();
				if (ps != null)
					ps.close();
			}
		}
		
		Long workitemID = null;
		String sql = null;
		int dbType = context.getDBManager().getDBType();
		if(dbType == DBType.MyCat) {
			sql = "select "
					+ dbManager.keyWordEscape(SystemDBField.WORKITEMID) + ","
					+ dbManager.keyWordEscape(SystemDBField.OPERATORID) + ","
					+ dbManager.keyWordEscape(SystemDBField.WORKITEMREVOKE) + ","
					+ dbManager.keyWordEscape(SystemDBField.TRANSACTIONID) 
					+ " from " 
					+ dbManager.keyWordEscape(SystemDBField.BPM_TRANSACTION) 
					+ " where "
					+ dbManager.keyWordEscape(SystemDBField.INSTANCEID) + "=? order by "
					+ dbManager.keyWordEscape(SystemDBField.TRANSACTIONID) + " desc";
		}else {
			sql = "select "
					+ dbManager.keyWordEscape(SystemDBField.WORKITEMID) + ","
					+ dbManager.keyWordEscape(SystemDBField.OPERATORID) + ","
					+ dbManager.keyWordEscape(SystemDBField.WORKITEMREVOKE)
					+ " from " 
					+ dbManager.keyWordEscape(SystemDBField.BPM_TRANSACTION) 
					+ " where "
					+ dbManager.keyWordEscape(SystemDBField.INSTANCEID) + "=? order by "
					+ dbManager.keyWordEscape(SystemDBField.TRANSACTIONID) + " desc";
		}

		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = context.getDBManager().preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addLongArg(instanceID);
			Long userID = context.getVE().getEnv().getUserID();
			rs = context.getDBManager().executeQuery(ps, sql, args);

			if (rs.next()) {
				if (rs.getInt(3) == 1 && userID.equals(rs.getLong(2)))
					workitemID = rs.getLong(1);
			}
			
		} finally {
			if (rs != null)
				rs.close();
			if (ps != null)
				ps.close();
		}
		
		if (workitemID != null) {
			MetaNode node = getNode(context, workitemID, processKey, verID, instanceID);
			if (node != null && node.isWorkitemRevoke() && canRevoke(context, node)) {
				RevokeWorkitemCmd cmd = new RevokeWorkitemCmd(workitemID);
				cmd.setUserInfo(userInfo);
				cmd.doCmd(new BPMContext(context));
			}
		}
	}
	
	private MetaNode getNode(DefaultContext context, Long workitemID, String processKey, Integer version,
			Long instanceID) throws Throwable {
		int inlineNodeID = -1;
		int nodeID = -1;

		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			IDBManager dbManager = context.getDBManager();
			String sql = "select "
					+ dbManager.keyWordEscape(SystemDBField.INLINENODEID) + ","
					+ dbManager.keyWordEscape(SystemDBField.NODEID)
					+ " from " 
					+ dbManager.keyWordEscape(SystemDBField.BPM_WORKITEMINFO) 
					+ " where "
					+ dbManager.keyWordEscape(SystemDBField.WORKITEMID) + "=?";
			ps = context.getDBManager().preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addLongArg(workitemID);
			rs = context.getDBManager().executeQuery(ps, sql, args);

			if (rs.next()) {
				inlineNodeID = rs.getInt(1);
				nodeID = rs.getInt(2);
				rs.close();
			} else
				return null;
		} finally {
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (ps != null) {
				ps.close();
				ps = null;
			}
		}

		MetaProcess main = BPMUtil.getProcessDefinationBy(context.getVE(), processKey, version);

		MetaProcess pd = main;
		if (inlineNodeID > 0) {
			MetaInline inlineNode = (MetaInline) BPMUtil.getNode(context.getVE(), pd, inlineNodeID);
			String inlineProcessKey = BPMUtil.getInlineProcessKey(inlineNode, context, instanceID);
			pd = BPMUtil.getProcessDefinationByDeployKey(context.getVE(), inlineProcessKey);
		}

		MetaNode node = BPMUtil.getNode(context.getVE(), pd, nodeID);
		return node;

	}
	
	private boolean canRevoke(DefaultContext context, MetaNode item) throws Throwable {
		String dd = item.getRevokeCondition();
		if (dd != null && !dd.isEmpty()) {
			Object tv = context.getMidParser().eval(ScriptType.Formula, dd, null, null);
			return TypeConvertor.toBoolean(tv);
		}
		return true;
	}
}
