package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;

public class RebindInstance {
	
	public void rebind(DefaultContext context, Document doc, String formKey, String processKey)throws Throwable{
		if (doc == null || doc.getOID() <= 0) {
			return ;
		}
		rebind(context, doc.getOID(), formKey, processKey);
	}
	
	
	public void rebind(DefaultContext context, long OID, String formKey, String processKey)throws Throwable{
		BPMContext bpmContext = new BPMContext(context);
		BPMInstance instance = BPMInstanceFactory.getBPMInstanceByOID(bpmContext, OID, false);
		if (instance == null) {
			return;
		}
		instance.deleteInstance(bpmContext);
		//执行删除操作
		bpmContext.getInstanceDataContainer().save();
		
		//启动流程
		bpmContext.reset();
		StartInstance startInstance = new StartInstance();
		startInstance.start(bpmContext, OID, formKey, processKey);
	}
	
}
