package com.bokesoft.yigo.bpm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.json.JSONObject;

import com.bokesoft.yes.log.base.BaseInfo;
import com.bokesoft.yes.log.base.ILoadSvr;
import com.bokesoft.yes.log.base.LoadSvr;
import com.bokesoft.yigo.bpm.analysis.AnalysisParas;
import com.bokesoft.yigo.bpm.analysis.DefaultAnalysisMode;
import com.bokesoft.yigo.bpm.analysis.AnalysisDefaultModeFactory;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.bpm.analysis.IAnalysisMode;

/**
 * 获取流程实例的分析数据
 * 
 * @author guowj
 *
 */
public class GetAnalysisData {
	
	/**
	 * @param metaTable 数据表配置对象
	 * @param paras 流程数据分析的参数
	 * @return
	 * @throws Throwable
	 */
	public DataTable getAnalysisData(MetaTable metaTable, AnalysisParas paras) throws Throwable {
		
		DataTable table = null;
		
		ArrayList<JSONObject> logDataList = new ArrayList<JSONObject>();
		
		// 读取base.conf文件
		BaseInfo info = new BaseInfo();
		info.loadproperties();
		
		ILoadSvr ils = LoadSvr.getInstance();
		
		// 加载的过滤条件
		List<String> keys = new ArrayList<String>();
		for(String condition : info.getCondition()) {
			keys.add(condition);
		}
	    
		List<Map<String, String>> list = ils.search(info.getLevel(), info.getUrl(), keys);
		for(Map<String, String> map : list) {
			JSONObject json = new JSONObject(map);
			logDataList.add(json);
		}
		
		String processKey = paras.getProcessKey();
		Long instanceID = paras.getInstanceID();
		Long workitemID = paras.getWorkitemID();
		
		// 默认分析模式有两种
		String analysisType = "";
		if(paras.getAnalysisMode() == null && paras.getWorkitemID() == null) {
			analysisType = DefaultAnalysisMode.S_Default_InstanceDuration;
		}else if(paras.getAnalysisMode() == null && paras.getWorkitemID() != null) {
			analysisType = DefaultAnalysisMode.S_Default_WorkitemDuration;
		}
		
		if(!analysisType.equalsIgnoreCase("")) {
			// 默认分析模式
			IAnalysisMode aType = AnalysisDefaultModeFactory.getAnalysisDefaultMode(analysisType);
			if(aType == null) {
				return null;
			}
			table = aType.getData(metaTable, processKey, instanceID, workitemID, logDataList);
			return table;
		}else {
			// 自定义分析模式
			IAnalysisMode mode = paras.getAnalysisMode();
			table = mode.getData();
			return table;
		}		
	}

}
