/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.workitem.data;

import com.bokesoft.yes.bpm.engine.common.Result;
import com.bokesoft.yes.bpm.engine.data.OIDRef;
import com.bokesoft.yes.bpm.workitem.data.RParticipator;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.bpm.workitem.data.TParticipatorRB;
import com.bokesoft.yes.bpm.workitem.data.TWorkitemRB;
import com.bokesoft.yes.bpm.workitem.data.a;
import com.bokesoft.yes.bpm.workitem.data.b;
import com.bokesoft.yes.mid.cache.RowKey;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.ArrayList;
import java.util.TreeSet;

public class WorkitemDataContainer {
    private b workitem = null;
    private a participator = null;
    private TWorkitemRB workitemRB = null;
    private TParticipatorRB participatorRB = null;
    private final OIDRef OID;

    public WorkitemDataContainer(OIDRef oIDRef) {
        this.OID = oIDRef;
        this.workitem = new b(oIDRef);
        this.participator = new a(oIDRef);
        this.workitemRB = new TWorkitemRB(oIDRef);
        this.participatorRB = new TParticipatorRB(oIDRef);
    }

    public void rollback(IDBManager iDBManager, int n2, TreeSet<Long> treeSet) throws Throwable {
        this.workitem.loadData(iDBManager, treeSet);
        this.participator.loadData(iDBManager, treeSet);
        this.workitemRB.loadData(iDBManager, treeSet);
        this.participatorRB.loadData(iDBManager, treeSet);
        this.workitemRB.rollback(this.workitem, n2);
        this.participatorRB.rollback(this.participator, n2);
        this.workitem.submit(iDBManager);
        this.participator.submit(iDBManager);
        this.workitemRB.submit(iDBManager);
        this.participatorRB.submit(iDBManager);
        this.workitem = new b(this.OID);
        this.participator = new a(this.OID);
        this.workitemRB = new TWorkitemRB(this.OID);
        this.participatorRB = new TParticipatorRB(this.OID);
    }

    public void deleteUnfinishedData(IDBManager object, TreeSet<Long> object22) throws Throwable {
        this.workitem.loadData((IDBManager)object, (TreeSet<Long>)object22);
        this.participator.loadData((IDBManager)object, (TreeSet<Long>)object22);
        for (RWorkitem rWorkitem : this.workitem.getWorkitemList()) {
            if (rWorkitem.getWorkitemState() == 2 || (rWorkitem.getMarkState() & 4) != 0) continue;
            rWorkitem.setWorkitemState(3);
        }
    }

    public void recoverHidedData(IDBManager object, TreeSet<Long> object22) throws Throwable {
        this.workitem.loadData((IDBManager)object, (TreeSet<Long>)object22);
        this.participator.loadData((IDBManager)object, (TreeSet<Long>)object22);
        for (RWorkitem rWorkitem : this.workitem.getWorkitemList()) {
            if (rWorkitem.getWorkitemState() != 3) continue;
            rWorkitem.setWorkitemState(1);
        }
    }

    public void removeUnfinishedData(IDBManager object, TreeSet<Long> object22) throws Throwable {
        this.workitem.loadData((IDBManager)object, (TreeSet<Long>)object22);
        this.participator.loadData((IDBManager)object, (TreeSet<Long>)object22);
        for (RWorkitem rWorkitem : this.workitem.getWorkitemList()) {
            if (rWorkitem.getWorkitemState() == 2 || (rWorkitem.getMarkState() & 4) != 0) continue;
            rWorkitem.setDeleted();
            rWorkitem.setAuditResult(-4);
            this.deleteParticipatorData(rWorkitem.getWorkItemID());
        }
    }

    public void removeUnfinishedData(BPMContext bPMContext, TreeSet<Long> object, int n2, String string) throws Throwable {
        IDBManager object22 = bPMContext.getDBManager();
        this.workitem.loadData(object22, (TreeSet<Long>)((Object)object));
        this.participator.loadData(object22, (TreeSet<Long>)((Object)object));
        for (RWorkitem rWorkitem : this.workitem.getWorkitemList()) {
            if (rWorkitem.getWorkitemState() == 2 || rWorkitem.getWorkitemState() == 3 || (rWorkitem.getMarkState() & 4) != 0) continue;
            rWorkitem.setAuditResult(n2);
            rWorkitem.setUserInfo(string);
            rWorkitem.setResultInfo(Result.parseToString(n2));
            rWorkitem.setOperatorID(bPMContext.getCurUserID());
            rWorkitem.setDeleted();
            this.deleteParticipatorData(rWorkitem.getWorkItemID());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void markUnfinishedData(IDBManager object, TreeSet<Long> object22, int n2) throws Throwable {
        this.workitem.loadData((IDBManager)object, (TreeSet<Long>)object22);
        this.participator.loadData((IDBManager)object, (TreeSet<Long>)object22);
        for (RWorkitem rWorkitem : this.workitem.getWorkitemList()) {
            void var3_5;
            if (rWorkitem.getWorkitemState() != 1) continue;
            int n3 = rWorkitem.getMarkState();
            rWorkitem.setMarkState(n3 | var3_5);
        }
    }

    public TreeSet<Long> getMarkedData(IDBManager object, TreeSet<Long> object2, int n2) throws Throwable {
        this.workitem.loadData((IDBManager)object, (TreeSet<Long>)object2);
        this.participator.loadData((IDBManager)object, (TreeSet<Long>)object2);
        object = new TreeSet();
        for (RWorkitem rWorkitem : this.workitem.getWorkitemList()) {
            if ((rWorkitem.getMarkState() & n2) == 0) continue;
            ((TreeSet)object).add(rWorkitem.getWorkItemID());
        }
        return object;
    }

    public RWorkitem getWorkitemData(DefaultContext defaultContext, Long l2) throws Throwable {
        Long l3 = l2;
        Object object = this.workitem;
        RowKey rowKey = new RowKey();
        rowKey.put((Object)l3);
        object = (RWorkitem)object.getRow(rowKey);
        if (object == null) {
            object = this.workitem.a(defaultContext.getDBManager(), l2);
            this.participator.loadData(defaultContext.getDBManager(), l2);
        }
        return object;
    }

    public Long searchAutoOpertor(DefaultContext object, Long l2) throws Throwable {
        this.getWorkitemData((DefaultContext)object, l2);
        object = this.participator.getParticipatorData(l2);
        if (((ArrayList)object).size() > 0) {
            return ((RParticipator)((Object)((ArrayList)object).get(0))).getOperatorID();
        }
        return 21L;
    }

    public void deleteWorkitemData(DefaultContext defaultContext, Long l2) throws Throwable {
        this.getWorkitemData(defaultContext, l2).setDeleted();
        this.participator.deleteParticipatorData(l2);
    }

    public ArrayList<RParticipator> getParticipatorData(Long l2) {
        return this.participator.getParticipatorData(l2);
    }

    public void submit(IDBManager iDBManager, Integer n2) throws Throwable {
        this.workitemRB.createRBData(this.workitem, n2);
        this.participatorRB.createRBData(this.participator, n2);
        this.workitem.submit(iDBManager);
        this.workitemRB.submit(iDBManager);
        this.participator.submit(iDBManager);
        this.participatorRB.submit(iDBManager);
        this.workitem = new b(this.OID);
        this.participator = new a(this.OID);
    }

    public void addNewWorkitemData(RWorkitem rWorkitem) {
        this.workitem.addRow(rWorkitem);
    }

    public void addNewParticipatorData(RParticipator rParticipator) {
        this.participator.addRow(rParticipator);
    }

    public void deleteParticipatorData(Long l2) {
        this.participator.deleteParticipatorData(l2);
    }

    public void deleteParticipatorData(Long object, Long l2) {
        Long l3 = l2;
        l2 = object;
        object = this.participator;
        RowKey rowKey = new RowKey();
        rowKey.put((Object)l2);
        rowKey.put((Object)l3);
        ((RParticipator)object.getRow(rowKey)).setDeleted();
    }

    public void reTreatParticipator(DefaultContext defaultContext, Long l2, Long l3, Long l4) throws Throwable {
        this.getWorkitemData(defaultContext, l2);
        this.participator.a(l2, l3, l4);
    }

    public ArrayList<RWorkitem> getWorkitemList() {
        return this.workitem.getWorkitemList();
    }

    public RParticipator getParticipator(Long l2, Long l3) {
        RowKey rowKey = new RowKey();
        rowKey.put((Object)l2);
        rowKey.put((Object)l3);
        return (RParticipator)this.participator.getRow(rowKey);
    }

    public void deleteAll(IDBManager iDBManager, TreeSet<Long> object) throws Throwable {
        this.workitem.loadData(iDBManager, (TreeSet<Long>)object);
        this.participator.loadData(iDBManager, (TreeSet<Long>)object);
        this.workitemRB.loadData(iDBManager, (TreeSet<Long>)object);
        this.participatorRB.loadData(iDBManager, (TreeSet<Long>)object);
        object = this.workitem.iterator();
        while (object.hasNext()) {
            ((RWorkitem)((Object)object.next())).setDeleted();
        }
        object = this.participator.iterator();
        while (object.hasNext()) {
            ((RParticipator)((Object)object.next())).setDeleted();
        }
        object = this.workitemRB.iterator();
        while (object.hasNext()) {
            ((RWorkitem)((Object)object.next())).setDeleted();
        }
        object = this.participatorRB.iterator();
        while (object.hasNext()) {
            ((RParticipator)((Object)object.next())).setDeleted();
        }
        this.workitem.submit(iDBManager);
        this.participator.submit(iDBManager);
        this.workitemRB.submit(iDBManager);
        this.participatorRB.submit(iDBManager);
    }
}

