/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.data.row.RLog;
import com.bokesoft.yes.bpm.engine.data.row.RTransaction;
import com.bokesoft.yes.bpm.engine.data.row.RWorkitemInfo;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.util.ProcessUtil;
import com.bokesoft.yes.bpm.i18n.StringTable;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.timer.TimerProxy;
import com.bokesoft.yes.bpm.util.SysTopicUtil;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.gop.bpm.IExecutionContext;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.parser.ParserException;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.struct.document.Document;
import java.sql.Timestamp;
import java.util.TreeSet;

public class RevokeWorkitemCmd
extends BPMServiceCmd {
    public static final String TAG_NAME = "RevokeWorkitem";
    private long workitemID = -1L;
    private String userInfo = null;

    public RevokeWorkitemCmd() {
    }

    public RevokeWorkitemCmd(long l2) {
        this.workitemID = l2;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(String string) {
        this.userInfo = string;
    }

    public IServiceCmd<BPMContext> newInstance() {
        return new RevokeWorkitemCmd();
    }

    @Override
    public void dealArguments(BPMContext bPMContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.workitemID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"workitemID"));
        if (stringHashMap.containsKey((Object)"userInfo")) {
            this.userInfo = TypeConvertor.toString((Object)stringHashMap.get((Object)"userInfo"));
        }
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        Object object = WorkitemUtil.loadWorkitem(bPMContext, (Long)this.workitemID);
        if (object == null) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)6, (Object[])new Object[0]);
        }
        bPMContext = BPMContext.getBPMContext(bPMContext, ((Workitem)object).getInstanceID());
        bPMContext.setOID(((Workitem)object).getOID());
        Object object2 = BPMInstanceFactory.getBPMInstance(bPMContext, ((Workitem)object).getInstanceID());
        int n2 = ((BPMInstance)object2).getInstanceData().getInstance().getData().getInstanceState();
        long l2 = ((BPMInstance)object2).getInstanceID();
        if (n2 == 4) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)23, (Object[])new Object[0]);
        }
        MetaProcess metaProcess = BPMUtil.getProcessByInstance(bPMContext, (BPMInstance)object2);
        Object object3 = metaProcess.getNodeByID(((Workitem)object).getNodeID());
        Object object4 = object3.getRevokeCondition();
        object4 = bPMContext.getMidParser().eval(0, (String)object4, null, null);
        if (object4 instanceof String) {
            throw new ParserException(6, (String)object4);
        }
        if (object4 != null && !((Boolean)object4).booleanValue()) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)17, (Object[])new Object[0]);
        }
        int n3 = object3.getNodeType();
        if (n3 != 2 && n3 != 3 && n3 != 4) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)38, (Object[])new Object[0]);
        }
        RWorkitem rWorkitem = ((BPMInstance)object2).getMainInstance().getWorkitemData().getWorkitemData(bPMContext, this.workitemID);
        if ((rWorkitem.getMarkState() & 0x10) != 0 || (rWorkitem.getMarkState() & 0x20) != 0) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)38, (Object[])new Object[0]);
        }
        long l3 = -1L;
        long l4 = -1L;
        if (n3 == 4) {
            l3 = rWorkitem.getSrcOperatorID() > 0L ? rWorkitem.getSrcOperatorID() : rWorkitem.getOperatorID();
            l4 = ((BPMInstance)object2).getMainInstance().getInstanceData().getNodeParticipator().getPriorOperator(object3.getID(), l3, bPMContext.getDBManager());
        }
        long l5 = -1L;
        int n4 = -1;
        boolean bl = false;
        long l6 = -1L;
        if (n3 == 4 && l4 > 0L) {
            l6 = l4;
            l5 = ((BPMInstance)object2).getMainInstance().getInstanceData().getNodeParticipator().getWorkitemID(object3.getID(), l6, bPMContext.getDBManager());
            n4 = ((BPMInstance)object2).getInstanceData().getTransaction().getStatusByWorkitemID(l5, bPMContext.getDBManager());
            object3 = ((BPMInstance)object2).getMainInstance().getInstanceData().getWorkitemInfo().getWorkitemInfo(l5, bPMContext.getDBManager());
            bl = ((BPMInstance)object2).getNodeByID(((RWorkitemInfo)object3).getInlineNodeID(), ((RWorkitemInfo)object3).getNodeID()).getNodeModel().isWorkitemRevoke();
        } else {
            object3 = ((BPMInstance)object2).getMainInstance().getInstanceData().getWorkitemInfo().getWorkitemInfo(this.workitemID, bPMContext.getDBManager());
            if (((RWorkitemInfo)object3).getParentWorkitemID() > 0L) {
                l5 = ((RWorkitemInfo)object3).getParentWorkitemID();
                n4 = ((BPMInstance)object2).getInstanceData().getTransaction().getStatusByWorkitemID(l5, bPMContext.getDBManager());
                object3 = ((BPMInstance)object2).getMainInstance().getInstanceData().getWorkitemInfo().getWorkitemInfo(l5, bPMContext.getDBManager());
                bl = ((BPMInstance)object2).getNodeByID(((RWorkitemInfo)object3).getInlineNodeID(), ((RWorkitemInfo)object3).getNodeID()).getNodeModel().isWorkitemRevoke();
                l6 = ((BPMInstance)object2).getMainInstance().getWorkitemData().getWorkitemData(bPMContext, l5).getOperatorID();
            }
        }
        int n5 = ((BPMInstance)object2).getInstanceData().getTransaction().rollbackToWorkitem(bPMContext, this.workitemID, Boolean.TRUE, bPMContext.getDBManager());
        if (n5 > 0) {
            TimerProxy.removeNodeData(bPMContext.getDBManager(), l2, n5);
        }
        if (n2 == 2) {
            ((BPMInstance)object2).getInstanceData().getInstance().getData().setInstanceState(1);
            ((BPMInstance)object2).getInstanceData().getInstance().getData().setEndTime(null);
            ((BPMInstance)object2).getInstanceData().getInstance().getData().setCostTime(null);
            this.addRevokeLog((BPMInstance)object2, bPMContext);
        }
        n5 = ((Workitem)object).getNodeID();
        for (Integer n6 : ProcessUtil.getSubsequences(bPMContext, n5, metaProcess)) {
            ((BPMInstance)object2).getInstanceData().getToken().deleteTokenByNodeID(n6, bPMContext.getDBManager());
            ((BPMInstance)object2).getInstanceData().getStepInfo().deleteStepInfoByTargetNodeID(n6);
        }
        TreeSet<Long> treeSet = WorkitemUtil.getSubsequenceWorkitems(bPMContext, n5, l2, metaProcess);
        if (this.userInfo == null || this.userInfo.isEmpty()) {
            this.userInfo = StringTable.getString((ILocale)bPMContext.getEnv(), (String)"", (String)"DefaultRevokeUserInfo");
        }
        ((BPMInstance)object2).getMainInstance().getWorkitemData().removeUnfinishedData(bPMContext, treeSet, -5, this.userInfo);
        treeSet = this.filterWorkitemID((BPMInstance)object2, bPMContext, treeSet);
        ((BPMInstance)object2).getMainInstance().getInstanceData().getWorkitemInfo().deleteDataByWIDs(treeSet, bPMContext.getDBManager());
        if (n3 == 4) {
            ((BPMInstance)object2).getMainInstance().getInstanceData().getNodeParticipator().deleteNodeParticipator(n5, l3, bPMContext.getDBManager());
        }
        RTransaction rTransaction = new RTransaction(((Workitem)object).getInstanceID());
        rTransaction.setTransactionID(((BPMInstance)object2).getInstanceData().getInstance().getData().getTransactionID());
        rTransaction.setWorkitemID(l5);
        rTransaction.setOperatorID(l6);
        rTransaction.setworkitemRevoke(bl);
        rTransaction.setStatusValue(n4);
        ((BPMInstance)object2).getInstanceData().getTransaction().addRow(rTransaction);
        int n7 = ((BPMInstance)object2).getMainInstance().applyNewTokenID();
        ((BPMInstance)object2).getMainInstance().getInstanceData().getToken().createNewToken(n7, -1);
        bPMContext.setActiveTokenID(n7);
        Workitem workitem = WorkitemUtil.loadWorkitem(bPMContext, (Long)l5);
        bPMContext.setUpdateWorkitem(workitem);
        object = ((BPMInstance)object2).getNodeByID(((Workitem)object).getInlineNodeID(), ((Workitem)object).getNodeID());
        bPMContext.setRevoke(true);
        bPMContext.setRevokeWorkitemID(this.workitemID);
        object.input((IExecutionContext)bPMContext);
        if (n2 == 2 && (object2 = ((BPMInstance)object2).getMainInstance().getEndNode().getRevokeTrigger()) != null && ((String)object2).length() > 0) {
            bPMContext.getMidParser().eval(0, (String)object2, null, null);
        }
        if ((object2 = ((ExecNode)((Object)object)).getNodeModel().getRevokeTrigger()) != null && ((String)object2).length() > 0) {
            bPMContext.getMidParser().eval(0, (String)object2, null, null);
        }
        if ((object2 = bPMContext.getDocument()) != null && object2.isModified()) {
            SysTopicUtil.assignSysTopic(bPMContext);
            new SaveData(object2.getMetaDataObject(), null, (Document)object2).midLaunchSave((DefaultContext)bPMContext);
        }
        bPMContext.getInstanceDataContainer().save();
        return Boolean.TRUE;
    }

    private void addRevokeLog(BPMInstance bPMInstance, BPMContext bPMContext) throws Throwable {
        Timestamp timestamp = new Timestamp(bPMContext.getDBManager().getCurTime());
        RLog rLog = new RLog(bPMInstance.getInstanceID());
        rLog.setLogID(bPMInstance.getMainInstance().applyNewLogID());
        rLog.setInlineNodeID(-1);
        rLog.setCreatTime(timestamp);
        rLog.setLogIndex(bPMInstance.getMainInstance().applyNewLogIndexID());
        rLog.setNodeID(bPMInstance.getMainInstance().getEndNode().getID());
        rLog.setAuditResult(-5);
        if (this.userInfo == null || this.userInfo.isEmpty()) {
            this.userInfo = StringTable.getString((ILocale)bPMContext.getEnv(), (String)"", (String)"DefaultRevokeUserInfo");
        }
        rLog.setUserInfo(this.userInfo);
        rLog.setFinishTime(timestamp);
        rLog.setOperatorID(bPMContext.getCurUserID());
        rLog.setWorkitemName(bPMInstance.getMainInstance().getEndNode().getCaption());
        rLog.setWorkitemState(4);
        rLog.setWorkitemID(-1L);
        bPMInstance.getInstanceData().getLog().addRow(rLog);
    }

    private TreeSet<Long> filterWorkitemID(BPMInstance bPMInstance, BPMContext bPMContext, TreeSet<Long> object) throws Throwable {
        TreeSet<Long> treeSet = new TreeSet<Long>();
        int n2 = bPMInstance.getMainInstance().getInstanceData().getWorkitemInfo().getWorkitemInfo(this.workitemID, bPMContext.getDBManager()).getTransactionID();
        object = ((TreeSet)object).iterator();
        while (object.hasNext()) {
            Long l2 = (Long)object.next();
            if (bPMInstance.getMainInstance().getInstanceData().getWorkitemInfo().getWorkitemInfo(l2, bPMContext.getDBManager()).getTransactionID() <= n2) continue;
            treeSet.add(l2);
        }
        return treeSet;
    }

    @Override
    public String getCmd() {
        return TAG_NAME;
    }
}

