/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.common.Result;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.instance.CreateNodeUtil;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.meta.transform.ManualTransferInfo;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.tools.json.JSONUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.json.JSONObject;

public class ManualTransferToNodeCmd
extends BPMServiceCmd {
    public static final String TAG_NAME = "ManualTransferToNode";
    private ManualTransferInfo info = null;

    public ManualTransferToNodeCmd() {
    }

    public ManualTransferToNodeCmd(String string) throws Throwable {
        if (JSONUtil.isJSONObject((String)string)) {
            this.info = new ManualTransferInfo();
            this.info.fromJSON(new JSONObject(string));
        }
    }

    public IServiceCmd<BPMContext> newInstance() {
        return new ManualTransferToNodeCmd();
    }

    @Override
    public void dealArguments(BPMContext object, StringHashMap<Object> stringHashMap) throws Throwable {
        object = TypeConvertor.toString((Object)stringHashMap.get((Object)"manualTransferInfo"));
        if (JSONUtil.isJSONObject((String)object)) {
            this.info = new ManualTransferInfo();
            this.info.fromJSON(new JSONObject((String)object));
        }
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        ExecNode execNode;
        if (this.info == null) {
            return null;
        }
        long l2 = this.info.getInstanceID();
        long l3 = this.info.getWorkitemID();
        Workitem workitem = null;
        if (l3 > 0L) {
            workitem = this.loadWorkitem(bPMContext, l3);
            l2 = workitem.getInstanceID();
        }
        bPMContext = BPMContext.getBPMContext(bPMContext, (Long)l2);
        bPMContext.setUpdateWorkitem(workitem);
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, l2);
        if (bPMInstance == null) {
            return null;
        }
        MetaProcess metaProcess = BPMUtil.getProcessByInstance(bPMContext, bPMInstance);
        metaProcess.getKey();
        long l4 = this.info.getSrcOperator() > 0L ? this.info.getSrcOperator() : bPMContext.getCurUserID().longValue();
        if (l4 > 0L) {
            bPMContext.setSrcOperator(l4);
        }
        if (l4 != 21L) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)24, (Object[])new Object[0]);
        }
        int n2 = this.info.getTransferTo();
        int n3 = workitem == null ? this.info.getNodeID() : workitem.getNodeID();
        int n4 = workitem == null ? this.info.getInlineNodeID().intValue() : workitem.getInlineNodeID();
        ExecNode execNode2 = bPMInstance.getNodeByID(n4, n3);
        execNode2.manualTransfer(bPMContext, this.info);
        try {
            execNode = bPMInstance.getNodeByID(-1, n2);
        }
        catch (Throwable throwable) {
            execNode = this.createNode(bPMInstance.getMainInstance(), n2, execNode2, bPMContext);
        }
        if (execNode != null) {
            execNode.input(bPMContext);
        }
        if (this.info.isLock()) {
            WorkitemUtil.lockWorkitem(bPMContext, n2, l2, metaProcess);
        }
        bPMContext.getInstanceDataContainer().save();
        bPMContext = new JSONObject();
        bPMContext.put("result", true);
        return bPMContext;
    }

    @Override
    public String getCmd() {
        return TAG_NAME;
    }

    private ExecNode createNode(VirtualInstance object, int n2, ExecNode execNode, BPMContext bPMContext) throws Throwable {
        Object object2 = ((VirtualInstance)object).getMetaNodeByID(n2);
        object = new CreateNodeUtil(bPMContext, (VirtualInstance)object);
        object2 = ((CreateNodeUtil)object).createNode((MetaNode)object2);
        ((CreateNodeUtil)object).handleExclusiveFork(execNode, (ExecNode)((Object)object2));
        ((CreateNodeUtil)object).handleJoin(execNode, (ExecNode)((Object)object2));
        return object2;
    }

    private Workitem loadWorkitem(BPMContext object, long l2) throws Throwable {
        if ((object = WorkitemUtil.loadWorkitem((DefaultContext)object, (Long)l2)) == null) {
            return null;
        }
        ((Workitem)object).setAuditResult(this.info.getAuditResult());
        ((Workitem)object).setUserInfo(this.info.getUserInfo());
        ((Workitem)object).setResultInfo(Result.parseToString(this.info.getAuditResult()));
        return object;
    }
}

