/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.node.assistance;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.node.assistance.Assistance;
import com.bokesoft.yes.bpm.engine.node.assistance.AssistanceAudit;
import com.bokesoft.yes.bpm.engine.node.assistance.AssistanceCountersign;
import com.bokesoft.yes.bpm.engine.node.assistance.AssistanceUserTask;
import com.bokesoft.yes.bpm.interpreter.INode;
import com.bokesoft.yes.bpm.interpreter.NodeFactoryProxy;
import com.bokesoft.yes.bpm.meta.transform.PPObject;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.HashMap;
import java.util.Iterator;

public class AssistanceNodeSet
implements Iterable<ExecNode> {
    private HashMap<Integer, ExecNode> nodeIDMap = new HashMap();
    private HashMap<String, ExecNode> nodeKeyMap = new HashMap();

    public AssistanceNodeSet(VirtualInstance virtualInstance, MetaUserTask object, NodeFactoryProxy nodeFactoryProxy) throws BPMError {
        for (MetaNode metaNode : object.getAssistanceCollection()) {
            ExecNode execNode = this.createNode(virtualInstance, metaNode, nodeFactoryProxy);
            INode iNode = nodeFactoryProxy.getProxyNode(execNode, virtualInstance);
            execNode.setInterprterNode(iNode);
            this.nodeIDMap.put(metaNode.getID(), execNode);
            this.nodeKeyMap.put(metaNode.getKey(), execNode);
        }
    }

    public void checkAndCreateNodeData(IDBManager iDBManager) throws Throwable {
        Iterator<ExecNode> iterator = this.nodeKeyMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().checkAndCreateNodeData(iDBManager);
        }
    }

    public void launchTask(BPMContext bPMContext, String string, PPObject pPObject) throws Throwable {
        ((Assistance)((Object)this.nodeKeyMap.get(string))).launchTaskBy(bPMContext, pPObject);
    }

    public ExecNode getNodeByID(int n2) {
        return this.nodeIDMap.get(n2);
    }

    public ExecNode getNodeByKey(String string) {
        return this.nodeKeyMap.get(string);
    }

    private ExecNode createNode(VirtualInstance virtualInstance, MetaNode metaNode, NodeFactoryProxy nodeFactoryProxy) throws BPMError {
        switch (metaNode.getNodeType()) {
            case 3: {
                return new AssistanceAudit(virtualInstance, metaNode, nodeFactoryProxy);
            }
            case 4: {
                return new AssistanceCountersign(virtualInstance, metaNode, nodeFactoryProxy);
            }
            case 2: {
                return new AssistanceUserTask(virtualInstance, metaNode, nodeFactoryProxy);
            }
        }
        throw BPMError.getBPMError(null, (int)1, (Object[])new Object[]{metaNode.getNodeType()});
    }

    @Override
    public Iterator<ExecNode> iterator() {
        return this.nodeIDMap.values().iterator();
    }
}

