/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.instance;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.engine.node.ExecAnchor;
import com.bokesoft.yes.bpm.engine.node.ExecAudit;
import com.bokesoft.yes.bpm.engine.node.ExecBegin;
import com.bokesoft.yes.bpm.engine.node.ExecBranchEnd;
import com.bokesoft.yes.bpm.engine.node.ExecComplexJoin;
import com.bokesoft.yes.bpm.engine.node.ExecCountersign;
import com.bokesoft.yes.bpm.engine.node.ExecDataMap;
import com.bokesoft.yes.bpm.engine.node.ExecDecision;
import com.bokesoft.yes.bpm.engine.node.ExecEnd;
import com.bokesoft.yes.bpm.engine.node.ExecEvent;
import com.bokesoft.yes.bpm.engine.node.ExecExclusiveFork;
import com.bokesoft.yes.bpm.engine.node.ExecExclusiveJoin;
import com.bokesoft.yes.bpm.engine.node.ExecFork;
import com.bokesoft.yes.bpm.engine.node.ExecGateWay;
import com.bokesoft.yes.bpm.engine.node.ExecInline;
import com.bokesoft.yes.bpm.engine.node.ExecJoin;
import com.bokesoft.yes.bpm.engine.node.ExecManualTask;
import com.bokesoft.yes.bpm.engine.node.ExecMessageReceive;
import com.bokesoft.yes.bpm.engine.node.ExecMessageSend;
import com.bokesoft.yes.bpm.engine.node.ExecMultiAudit;
import com.bokesoft.yes.bpm.engine.node.ExecMultiUserTask;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.node.ExecServiceTask;
import com.bokesoft.yes.bpm.engine.node.ExecState;
import com.bokesoft.yes.bpm.engine.node.ExecStateAction;
import com.bokesoft.yes.bpm.engine.node.ExecSub;
import com.bokesoft.yes.bpm.engine.node.ExecTimer;
import com.bokesoft.yes.bpm.engine.node.ExecUserTask;
import com.bokesoft.yes.bpm.interpreter.INode;
import com.bokesoft.yes.bpm.interpreter.NodeFactoryProxy;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBegin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEnd;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class NodeSet
implements Iterable<ExecNode> {
    private HashMap<Integer, ExecNode> nodeIDMap = new HashMap();
    private HashMap<String, ExecNode> nodeKeyMap = new HashMap();
    private HashMap<String, MetaNode> metaNodeKeyMap = new HashMap();
    private HashMap<Integer, MetaNode> metaNodeIDMap = new HashMap();
    private ExecBegin beginNode = null;
    private MetaEnd endNode = null;
    private VirtualInstance instance = null;
    private NodeFactoryProxy proxy = null;
    private TreeMap<Integer, Integer> assistanceMapByID = null;
    private HashMap<String, String> assistanceMapByKey = null;
    private HashMap<Integer, ExecNode> assistanceNodeMap = null;

    public NodeSet(VirtualInstance virtualInstance, MetaProcess metaProcess, NodeFactoryProxy iterator, BPMContext bPMContext) throws Throwable {
        this.instance = virtualInstance;
        this.proxy = iterator;
        for (MetaNode metaNode : metaProcess) {
            if (metaNode instanceof MetaEnd) {
                this.endNode = (MetaEnd)metaNode;
            }
            if (metaNode instanceof MetaBegin) {
                this.beginNode = (ExecBegin)this.handleCreateNode(metaNode);
            }
            this.metaNodeKeyMap.put(metaNode.getKey(), metaNode);
            this.metaNodeIDMap.put(metaNode.getID(), metaNode);
        }
        for (MetaNode metaNode : this.metaNodeIDMap.values()) {
            ExecNode execNode;
            if (virtualInstance.getInstanceData().getNode().getNodeData(metaNode.getID(), bPMContext.getDBManager()) == null || !((execNode = this.handleCreateNode(metaNode)) instanceof ExecUserTask)) continue;
            for (Object object : metaProcess.getPreNodesById(Integer.valueOf(metaNode.getID()))) {
                if ((object = metaProcess.getNodeByID(object.intValue())).getNodeType() != 16) continue;
                object = (ExecExclusiveFork)this.handleCreateForkJoinNode((MetaNode)object);
                ((ExecUserTask)execNode).setExclusiveFork((ExecExclusiveFork)((Object)object));
            }
            for (Object object : metaNode.getTransitionCollection()) {
                if (!(object instanceof MetaSequenceFlow) || object.getTargetNode().getNodeType() != 8 && object.getTargetNode().getNodeType() != 14 && object.getTargetNode().getNodeType() != 27) continue;
                if ((object = this.handleCreateForkJoinNode(object.getTargetNode())) instanceof ExecComplexJoin) {
                    ((ExecUserTask)execNode).setJoin((ExecComplexJoin)((Object)object));
                    continue;
                }
                ((ExecUserTask)execNode).setJoin((ExecJoin)((Object)object));
            }
        }
        this.assistanceMapByID = metaProcess.getAssistanceMapByID();
        this.assistanceMapByKey = metaProcess.getAssistanceMapByKey();
    }

    private ExecNode handleCreateNode(MetaNode metaNode) {
        ExecNode execNode = this.createNode(metaNode);
        INode iNode = this.getProxyNode(execNode);
        execNode.setInterprterNode(iNode);
        this.nodeIDMap.put(metaNode.getID(), execNode);
        this.nodeKeyMap.put(metaNode.getKey(), execNode);
        execNode.preProcess();
        this.buildAssistanceNodeMap(execNode);
        return execNode;
    }

    private ExecNode handleCreateForkJoinNode(MetaNode object) {
        object = this.createNode((MetaNode)object);
        INode iNode = this.getProxyNode((ExecNode)((Object)object));
        ((ExecNode)((Object)object)).setInterprterNode(iNode);
        ((ExecNode)((Object)object)).preProcess();
        return object;
    }

    public void putNodeIDMap(int n2, ExecNode execNode) {
        this.nodeIDMap.put(n2, execNode);
    }

    public void putNodeKeyMap(String string, ExecNode execNode) {
        this.nodeKeyMap.put(string, execNode);
    }

    public MetaNode getMetaNodeByNodeKey(String string) {
        MetaNode metaNode = this.metaNodeKeyMap.get(string);
        if (metaNode == null) {
            throw BPMError.getBPMError(null, (int)15, (Object[])new Object[]{string, this.instance.getDefinationKey()});
        }
        return metaNode;
    }

    public MetaNode getMetaNodeByID(Integer n2) {
        MetaNode metaNode = this.metaNodeIDMap.get(n2);
        if (metaNode == null) {
            throw BPMError.getBPMError(null, (int)15, (Object[])new Object[]{n2, this.instance.getDefinationKey()});
        }
        return metaNode;
    }

    public INode getProxyNode(ExecNode execNode) {
        return this.proxy.getProxyNode(execNode, this.instance);
    }

    public void buildAssistanceNodeMap(ExecNode object) {
        if (object instanceof ExecUserTask) {
            for (ExecNode execNode : ((ExecUserTask)object).getAssistanceNodeSet()) {
                if (this.assistanceNodeMap == null) {
                    this.assistanceNodeMap = new HashMap();
                }
                this.assistanceNodeMap.put(execNode.getID(), execNode);
                this.buildAssistanceNodeMap(execNode);
            }
        }
    }

    public ExecNode createNode(MetaNode metaNode) throws BPMError {
        switch (metaNode.getNodeType()) {
            case 3: {
                return new ExecAudit(this.instance, metaNode, this.proxy);
            }
            case 0: {
                return new ExecBegin(this.instance, metaNode);
            }
            case 4: {
                return new ExecCountersign(this.instance, metaNode, this.proxy);
            }
            case 5: {
                return new ExecDecision(this.instance, metaNode);
            }
            case 1: {
                return new ExecEnd(this.instance, metaNode);
            }
            case 9: {
                return new ExecEvent(this.instance, metaNode);
            }
            case 7: {
                return new ExecFork(this.instance, metaNode);
            }
            case 8: {
                return new ExecJoin(this.instance, metaNode);
            }
            case 14: {
                return new ExecComplexJoin(this.instance, metaNode);
            }
            case 10: {
                return new ExecState(this.instance, metaNode);
            }
            case 6: {
                return new ExecSub(this.instance, metaNode, this.proxy);
            }
            case 2: {
                return new ExecUserTask(this.instance, metaNode, this.proxy);
            }
            case 11: {
                return new ExecTimer(this.instance, metaNode);
            }
            case 12: {
                return new ExecInline(this.instance, metaNode);
            }
            case 13: {
                return new ExecDataMap(this.instance, metaNode, this.proxy);
            }
            case 15: {
                return new ExecManualTask(this.instance, metaNode);
            }
            case 16: {
                return new ExecExclusiveFork(this.instance, metaNode);
            }
            case 17: {
                return new ExecServiceTask(this.instance, metaNode);
            }
            case 18: {
                return new ExecBranchEnd(this.instance, metaNode);
            }
            case 19: {
                return new ExecStateAction(this.instance, metaNode);
            }
            case 20: {
                return new ExecMultiUserTask(this.instance, metaNode, this.proxy);
            }
            case 21: {
                return new ExecMultiAudit(this.instance, metaNode, this.proxy);
            }
            case 22: {
                return new ExecGateWay(this.instance, metaNode);
            }
            case 26: {
                return new ExecMessageReceive(this.instance, metaNode);
            }
            case 25: {
                return new ExecMessageSend(this.instance, metaNode);
            }
            case 27: {
                return new ExecExclusiveJoin(this.instance, metaNode);
            }
            case 28: {
                return new ExecAnchor(this.instance, metaNode);
            }
        }
        throw BPMError.getBPMError(null, (int)1, (Object[])new Object[]{metaNode.getNodeType()});
    }

    public void startInstance(BPMContext bPMContext) throws Throwable {
        this.beginNode.begin(bPMContext);
    }

    public MetaEnd getEndNode() {
        return this.endNode;
    }

    public MetaBegin getBeginNode() {
        if (this.beginNode != null) {
            return (MetaBegin)this.beginNode.getNodeModel();
        }
        return null;
    }

    public ExecNode getNodeByID(int n2) {
        ExecNode execNode = this.nodeIDMap.get(n2);
        if (execNode == null && this.assistanceNodeMap != null) {
            execNode = this.assistanceNodeMap.get(n2);
        }
        if (execNode == null) {
            throw BPMError.getBPMError(null, (int)15, (Object[])new Object[]{n2, this.instance.getDefinationKey()});
        }
        return execNode;
    }

    public ExecNode getNodeByKey(String string) {
        Object object = this.nodeKeyMap.get(string);
        if (object == null) {
            object = this.assistanceMapByKey.get(string);
            if (object != null) {
                return ((ExecUserTask)this.nodeKeyMap.get(object)).getAssistanceNodeSet().getNodeByKey(string);
            }
        } else {
            return object;
        }
        throw BPMError.getBPMError(null, (int)15, (Object[])new Object[]{string, this.instance.getDefinationKey()});
    }

    @Override
    public Iterator<ExecNode> iterator() {
        return this.nodeIDMap.values().iterator();
    }
}

