/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.data.table;

import com.bokesoft.yes.bpm.engine.data.OIDRef;
import com.bokesoft.yes.bpm.engine.data.row.RToken;
import com.bokesoft.yes.bpm.engine.data.table.BPMTable;
import com.bokesoft.yes.bpm.engine.data.table.SplitTable;
import com.bokesoft.yes.bpm.engine.data.virtual.table.VTToken;
import com.bokesoft.yes.bpm.workitem.data.SqlHelper;
import com.bokesoft.yes.mid.cache.RowKey;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.HashMap;

public class TToken
extends BPMTable<RToken>
implements SplitTable<VTToken> {
    private static final String Source = "select * from  BPM_Token where instanceID=?";
    private static final String Delete = "delete  from  BPM_Token where instanceID=?   and tokenID=?";
    private static final String Update = "update  BPM_Token  set nodeID=? ,inlineNodeID=?,assistTransactionID=? where instanceID=?  and tokenID=?";
    private static final String Insert = "insert into  BPM_Token  (instanceID,OID,tokenID,nodeID,inlineNodeID,transactionID,assistTransactionID) values(?,?,?,?,?,?,?)";
    private static final String DeleteAll = "delete from BPM_Token  where instanceID=?";
    private HashMap<Integer, VTToken> vTTokenMap = new HashMap();

    public TToken(Long l2, OIDRef oIDRef) {
        super(l2, oIDRef);
    }

    @Override
    public String getDataSourceSql() {
        return Source;
    }

    @Override
    public String getDeleteSql() {
        return Delete;
    }

    @Override
    public String getUpdateSql() {
        return Update;
    }

    @Override
    public String getInsertSql() {
        return Insert;
    }

    @Override
    protected String getDeleteAllSql() {
        return DeleteAll;
    }

    public QueryArguments getDeletePSArgs(IDBManager iDBManager, RToken rToken) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        SqlHelper.dealInstanceID2ConditionArge(iDBManager, this.instanceID, this.OID, pSArgs);
        pSArgs.addIntArg(Integer.valueOf(rToken.getTokenID()));
        return pSArgs;
    }

    public QueryArguments getUpdatePSArgs(IDBManager iDBManager, RToken rToken) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        pSArgs.addIntArg(Integer.valueOf(rToken.getNodeID()));
        pSArgs.addIntArg(Integer.valueOf(rToken.getInlineNodeID()));
        pSArgs.addIntArg(rToken.getAssistTransactionID());
        SqlHelper.dealInstanceID2ConditionArge(iDBManager, this.instanceID, this.OID, pSArgs);
        pSArgs.addIntArg(Integer.valueOf(rToken.getTokenID()));
        return pSArgs;
    }

    @Override
    public QueryArguments getInsertPSArgs(RToken rToken) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        pSArgs.addLongArg(this.instanceID);
        pSArgs.addLongArg(Long.valueOf(this.OID.get()));
        pSArgs.addIntArg(Integer.valueOf(rToken.getTokenID()));
        pSArgs.addIntArg(Integer.valueOf(rToken.getNodeID()));
        pSArgs.addIntArg(Integer.valueOf(rToken.getInlineNodeID()));
        pSArgs.addIntArg(rToken.getTransactionID());
        pSArgs.addIntArg(rToken.getAssistTransactionID());
        return pSArgs;
    }

    public void removeAll(IDBManager object) throws Throwable {
        this.loadData((IDBManager)object);
        object = this.visableRows().iterator();
        while (object.hasNext()) {
            ((RToken)object.next()).setDeleted();
        }
    }

    public void deleteTokenByNodeID(int n2, IDBManager object) throws Throwable {
        this.loadData((IDBManager)object);
        for (RToken rToken : this.visableRows()) {
            if (rToken.getNodeID() != n2) continue;
            rToken.setDeleted();
        }
    }

    public void deleteToken(int n2, IDBManager iDBManager) throws Throwable {
        RowKey rowKey = new RowKey();
        rowKey.put((Object)this.instanceID);
        rowKey.put((Object)n2);
        RToken rToken = (RToken)this.getRow(rowKey);
        if (rToken == null) {
            this.loadData(iDBManager);
            rToken = (RToken)this.getRow(rowKey);
        }
        if (rToken != null) {
            rToken.setDeleted();
        }
    }

    @Override
    public RToken createEmptyRow() {
        return new RToken(this.instanceID);
    }

    @Override
    public VTToken split(int n2) {
        TToken tToken = this;
        VTToken vTToken = new VTToken(tToken, tToken.instanceID, n2);
        this.vTTokenMap.put(n2, vTToken);
        return vTToken;
    }

    private void loadData(IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        object = this.iterator();
        while (object.hasNext()) {
            RToken rToken = (RToken)object.next();
            this.vTTokenMap.get(rToken.getInlineNodeID()).internalAddRow(rToken);
        }
    }
}

