/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.extend.service;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class TransferTaskCmd
extends BPMServiceCmd {
    public static final String TAG = "TransferTask";
    private Long workitemID;
    private Long operatorID;
    private boolean createRecord;
    private String userinfo;
    private int auditResult;
    private long srcOperator;
    private int transferType;

    public TransferTaskCmd(Long l, Long l2, boolean bl, String string, int n) {
        this.workitemID = l;
        this.operatorID = l2;
        this.createRecord = bl;
        this.userinfo = string;
        this.auditResult = n;
    }

    public TransferTaskCmd() {
    }

    public void dealArguments(BPMContext bPMContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.workitemID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"WorkitemID"));
        this.operatorID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"OperatorID"));
        this.createRecord = TypeConvertor.toBoolean((Object)stringHashMap.get((Object)"CreateRecord"));
        this.userinfo = TypeConvertor.toString((Object)stringHashMap.get((Object)"UserInfo"));
        this.auditResult = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"AuditResult"));
        this.srcOperator = TypeConvertor.toLong((Object)stringHashMap.get((Object)"SrcOpt"));
        this.transferType = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"TransferType"));
    }

    public String getCmd() {
        return "";
    }

    public Object doCmd(BPMContext bPMContext) throws Throwable {
        long l;
        Workitem workitem = WorkitemUtil.loadWorkitem((DefaultContext)bPMContext, (Long)this.workitemID);
        if (workitem == null) {
            return "";
        }
        long l2 = l = this.srcOperator > 0L ? this.srcOperator : bPMContext.getCurUserID();
        if (!workitem.getParticipatorList().contains(l)) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)24, (Object[])new Object[0]);
        }
        bPMContext = BPMContext.getBPMContext((BPMContext)bPMContext, (Long)workitem.getInstanceID());
        bPMContext.setUpdateWorkitem(workitem);
        if (this.createRecord) {
            workitem.setWorkItemState(2);
            workitem.setAuditResult(this.auditResult);
            workitem.setUserInfo(this.userinfo);
        } else {
            workitem.setWorkItemState(1);
        }
        workitem.setTransferType(this.transferType);
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance((BPMContext)bPMContext, (Long)workitem.getInstanceID());
        if (bPMInstance != null) {
            bPMContext.setSrcOperator(this.srcOperator);
            bPMInstance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID()).transferTask(bPMContext, this.operatorID, this.createRecord);
        }
        bPMContext.getInstanceDataContainer().save();
        return null;
    }

    public int getTransferType() {
        return this.transferType;
    }

    public void setTransferType(int n) {
        this.transferType = n;
    }

    public void setSrcOperator(long l) {
        this.srcOperator = l;
    }

    public IServiceCmd<BPMContext> newInstance() {
        return new TransferTaskCmd();
    }
}

