/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.extend.service;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecUserTask;
import com.bokesoft.yes.bpm.meta.transform.PPObject;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.json.JSONObject;

public class LaunchTaskCmd
extends BPMServiceCmd {
    public static final String TAG = "LaunchTask";
    private long workitemID;
    private String nodeKey;
    private PPObject ppObject;
    private String launchInfo;
    private boolean hideActiveWorkitem;

    public LaunchTaskCmd(Long l, String string, PPObject pPObject, String string2, boolean bl) {
        this.workitemID = l;
        this.nodeKey = string;
        this.ppObject = pPObject;
        this.launchInfo = string2;
        this.hideActiveWorkitem = bl;
    }

    public LaunchTaskCmd() {
    }

    public void dealArguments(BPMContext bPMContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.workitemID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"WorkitemID"));
        this.nodeKey = (String)stringHashMap.get((Object)"NodeKey");
        this.launchInfo = (String)stringHashMap.get((Object)"LaunchInfo");
        this.hideActiveWorkitem = TypeConvertor.toBoolean((Object)stringHashMap.get((Object)"HideActiveWorkitem"));
        this.ppObject = new PPObject();
        this.ppObject.fromJSON(new JSONObject(stringHashMap.get((Object)"PPObject").toString()));
    }

    public String getCmd() {
        return "";
    }

    public Object doCmd(BPMContext bPMContext) throws Throwable {
        Workitem workitem = WorkitemUtil.loadWorkitem((DefaultContext)bPMContext, (Long)this.workitemID);
        if (workitem == null) {
            return "";
        }
        if (this.hideActiveWorkitem) {
            workitem.setWorkItemState(3);
            workitem.setHideActiveWorkitem(this.hideActiveWorkitem);
        } else {
            workitem.setWorkItemState(1);
        }
        workitem.setLaunchInfo(this.launchInfo);
        bPMContext = BPMContext.getBPMContext((BPMContext)bPMContext, (Long)workitem.getInstanceID());
        bPMContext.setUpdateWorkitem(workitem);
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance((BPMContext)bPMContext, (Long)workitem.getInstanceID());
        if (bPMInstance != null && (workitem = bPMInstance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID())) instanceof ExecUserTask) {
            ((ExecUserTask)workitem).launchTask(bPMContext, Long.valueOf(this.workitemID), this.nodeKey, this.ppObject);
        }
        bPMContext.getInstanceDataContainer().save();
        workitem = new JSONObject();
        workitem.put("result", true);
        return workitem;
    }

    public IServiceCmd<BPMContext> newInstance() {
        return new LaunchTaskCmd();
    }
}

