package com.bokesoft.yes.bpm.model;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBegin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageSend;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.node.NodeType;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransition;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;

/**
 * BPM帮助类
 */

public class BPMModelUtils {

	/**
	 * 创建BPM模型
	 * 
	 * @param meta 流程配置对象
	 */
	public static BPMProcessModel newBPMProcessModel(MetaProcess meta) {
		BPMProcessModel model = new BPMProcessModel();
		model.setKey(meta.getKey());
		model.setVersion(meta.getVersion());
		for (MetaNode metaNode : meta) {
			BPMNodeModel node = newBPMNodeModel(metaNode);
			model.addNode(node);
			if (metaNode instanceof MetaBegin) {
				model.setBeginNodeID(node.getID());
			}
		}
		return model;
	}

	/**
	 * 创建流程节点模型
	 * 
	 * @param meta 流程节点配置对象
	 */
	public static BPMNodeModel newBPMNodeModel(MetaNode meta) {
		BPMNodeModel model = new BPMNodeModel();
		model.setID(meta.getID());
		model.setKey(meta.getKey());

		List<Integer> nextNodeIDs = null;

		final int type;
		switch (meta.getNodeType()) {
		case NodeType.DECISION:
		case NodeType.GATE_WAY:
		case NodeType.JOIN:
		case NodeType.COMPLEX_JOIN:
		case NodeType.EXCLUSIVE_JOIN:
		case NodeType.EXCLUSIVE_FORK:
		case NodeType.STATE:
		case NodeType.STATE_ACTION:
		case NodeType.USER_TASK:
		case NodeType.AUDIT:
		case NodeType.COUNTERSIGN:
		case NodeType.MULTI_AUDIT:
		case NodeType.MULTI_USER_TASK:
			type = BPMNodeModelType.INTERFERE;
			break;
		case NodeType.MESSAGE_SEND:
			if (meta instanceof MetaMessageSend) {
				MetaMessageSend messageSend = (MetaMessageSend) meta;
				nextNodeIDs = new ArrayList<>();
				nextNodeIDs.add(messageSend.getID());
			}
		default:
			type = BPMNodeModelType.DIRECT;
			break;
		}
		model.setType(type);

		if (nextNodeIDs == null) {
			MetaTransitionCollection transitions = meta.getTransitionCollection();
			if (transitions != null) {
				nextNodeIDs = new ArrayList<>();
				for (MetaTransition transition : transitions) {
					if (!(transition instanceof MetaSequenceFlow)) {
						continue;
					}
					MetaNode target = transition.getTargetNode();
					if (target == null) {
						continue;
					}
					nextNodeIDs.add(target.getID());
				}
				if (!nextNodeIDs.isEmpty()) {
					model.setNextNodeIDs(nextNodeIDs);
				}
			}
		}
		return model;
	}
}
