package com.bokesoft.yes.bpm.common.exception;

import java.util.HashMap;

import com.bokesoft.yes.bpm.i18n.StringTable;
import com.bokesoft.yigo.common.exception.CoreException;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.SimpleStringFormat;

/**
 * 业务流程管理异常类，异常编码如下:
 * <p>
 * 
 * <pre>
 * 8009 0001 - 节点类型未定义
 * 8009 0002 - 参与者计算错误
 * </pre>
 * 
 * </p>
 * 
 * @author 刘翔翔
 * 
 */
public class BPMError extends CoreException {

	private static final long serialVersionUID = 1L;

	public static final int NO_DEFINE_NODE_TYPE = 0x0001;

	public static final int PARTICIPATOR_ERROR = 0x0002;

	public static final int DELEGATE_RIGHT_ERROR = 0x0003;

	public static final int INSTANCE_STARTED = 0x0004;

	public static final int WORKITEM_DATA_TIME_OUT = 0x0005;

	public static final int NO_ACTIVE_WORKITEM = 0x0006;

	public static final int NO_MAP_DATA = 0x0007;

	public static final int NO_PROCESS_DEFINATION = 0x0008;

	public static final int NO_BINDING_PROCESS = 0x0009;

	public static final int NO_DYNAMIC_BINDING_PROCESS = 0x000A;

	public static final int NO_PROCESS_DEFINATION_VERID = 0x000B;

	public static final int NO_INSTANCE_DATA = 0x000C;

	public static final int DELEGATE_MISS_SRC = 0x000D;

	public static final int DELEGATE_MISS_TGT = 0x000E;

	public static final int NO_NODE_EXIST = 0x000F;

	public static final int NO_BPM_CONTEXT = 0x0010;

	public static final int ROLLBACK_ERROR = 0x0011;

	public static final int NO_STANDARD_FORM = 0x0012;

	public static final int NO_FORM = 0x0013;

	public static final int NO_PATH = 0x0014;

	/** 缺少附件信息 */
	public static final int MISS_ATTACHMENT = 0x0015;
	/** 代理结束时间在开始时间之前*/
	public static final int DELEGATE_ENDTIME_BEFORE_STARTTIME = 0x0016;
	
	public static final int INSTANCE_PAUSED = 0x0017;
	
	public static final int COMMIT_RIGHT_ERROR = 0x0018;
	
	public static final int COMMIT_ERROR = 0x0019;
	
	public static final int COMMIT_NO_BACKSITE = 0x001A;
	
	public static final int COMMIT_NO_BACKSITE_OPT = 0x001B;
	
	public static final int COMMIT_NO_TRANSITTO = 0x001C;
	
	public static final int OUT_OF_PARTICIPATORS = 0x0020;
	
	/** 普通模式下不支持分配操作*/
	public static final int DISTRIBUTE_NOT_SUPPORT = 0x0021;
	
	/** 参与者计算错误*/
	public static final int PARTICIPATORS_CACL_ERROR = 0x001D;
	/** 节点{1}不支持转交操作*/
	public static final int TRANSFER_NOT_SUPPORT = 0x0022;
	/** 直送位置无参与者*/
	public static final int TRANSITTO_NO_PARTICIPATOR = 0x0023;
	public static final int DEFAULT_DELEGATE_LOG_USERINFO = 0x0024;
	public static final int DEFAULT_RETREATE_DELEGATE_LOG_USERINFO = 0x0025;
	
	/** 该节点不支持撤销操作*/
	public static final int NOT_ALLOWED_REVOKE = 0x0026;
	/** 消息发送报错*/
	public static final int MESSAGE_SEND_ERROR = 0x0027;
	/** 节点不支持消息操作*/
	public static final int MESSAGE_NOT_SUPPORT = 0x0028;
	/** 不支持驳回到无参与者自动略过的节点*/
	public static final int NO_PARTICIPATOR_AUTO_IGNORE_NOT_SUPPORT = 0x0029;
	/** 跳转模式下未定义跳转位置*/
	public static final int COMMIT_NO_STRAIGHTSITE = 0x002A;
	/** 操作员不一致*/
	public static final int OPERATOR_DISACCORD = 0x002B;
	/** 撤销工作项不存在*/
	public static final int NO_REVOKE_WORKITEM = 0x002C;
	/** 撤销工作项无参与者*/
	public static final int REVOKE_NO_PARTICIPATOR = 0x002D;
	/** 当前节点不是数据映射节点*/
	public static final int NODE_NOT_EXECDATAMAP = 0x002E;
	/** 内联流程的KEY不存在*/
	public static final int NO_INLINE_PROCESS_KEY = 0x002F;
	/** 不支持热部署低版本流程*/
	public static final int NOT_ALLOWED_HOT_DEPLOY_LOW_VERSION = 0x0030;
	/** 不支持撤销部署高版本流程*/
	public static final int NOT_ALLOWED_REVOKE_DEPLOY_HIGH_VERSION = 0x0031;
	/** 部署的目标流程不存在*/
	public static final int NO_TARGET_PROCESS_OF_DEPLOY = 0x0032;
	/** 流程标识和版本号不完整*/
	public static final int NO_PROCESSKEY_OR_VERID = 0x0033;
	/** 当前场景不支持热部署*/
	public static final int NOT_ALLOWED_HOT_DEPLOY = 0x0034;
	/** 当前场景不支持撤销部署*/
	public static final int NOT_ALLOWED_REVOKE_DEPLOY = 0x0035;
	/** 重复流程部署*/
	public static final int REPEAT_PROCESS_DEPLOY = 0x0036;
	/** 数据类型错误*/
	public static final int DATA_TYPE_ERROR = 0x0037;
	/** 重复流程保存*/
	public static final int REPEAT_PROCESS_SAVE = 0x0038;
	/** 不支持已部署流程的删除*/
	public static final int NOT_ALLOWED_DELETE_DEPLOYED_PROCESS = 0x0039;
	
	public static final int PARTICIPATOR_EXIST = 0x003A;

	private static final HashMap<Integer, String> errorInfoMap = new HashMap<Integer, String>();

	static {
		errorInfoMap.put(NO_DEFINE_NODE_TYPE, StringTable.NoDefineNodeType);
		errorInfoMap.put(PARTICIPATOR_ERROR, StringTable.ParticipatorError);
		errorInfoMap.put(DELEGATE_RIGHT_ERROR, StringTable.DelegateRightError);
		errorInfoMap.put(INSTANCE_STARTED, StringTable.InstanceStarted);
		errorInfoMap.put(WORKITEM_DATA_TIME_OUT, StringTable.WorkitemDataTimeout);
		errorInfoMap.put(NO_ACTIVE_WORKITEM, StringTable.NoActiveWorkitem);
		errorInfoMap.put(NO_MAP_DATA, StringTable.NoMApData);
		errorInfoMap.put(NO_PROCESS_DEFINATION, StringTable.NoProcessDefination);
		errorInfoMap.put(NO_BINDING_PROCESS, StringTable.NoBindingProcess);
		errorInfoMap.put(NO_DYNAMIC_BINDING_PROCESS, StringTable.NoDynamicBindingProcess);
		errorInfoMap.put(NO_PROCESS_DEFINATION_VERID, StringTable.NoProcessDefinationVerID);
		errorInfoMap.put(NO_INSTANCE_DATA, StringTable.NoInstanceData);
		errorInfoMap.put(DELEGATE_MISS_SRC, StringTable.DelegateMissSrc);
		errorInfoMap.put(DELEGATE_MISS_TGT, StringTable.DelegateMissTgt);
		errorInfoMap.put(NO_NODE_EXIST, StringTable.NoNodeExist);
		errorInfoMap.put(NO_BPM_CONTEXT, StringTable.NoBPMContext);
		errorInfoMap.put(ROLLBACK_ERROR, StringTable.RollbackError);
		errorInfoMap.put(NO_STANDARD_FORM, StringTable.NoStandardForm);
		errorInfoMap.put(NO_FORM, StringTable.NoForm);
		errorInfoMap.put(NO_PATH, StringTable.NoPath);
		errorInfoMap.put(MISS_ATTACHMENT, StringTable.MissAttachment);
		errorInfoMap.put(DELEGATE_ENDTIME_BEFORE_STARTTIME, StringTable.EndTimeBeforeStartTime);
		errorInfoMap.put(INSTANCE_PAUSED, StringTable.InstancePaused);
		errorInfoMap.put(COMMIT_RIGHT_ERROR, StringTable.CommitRightError);
		errorInfoMap.put(COMMIT_ERROR, StringTable.CommitError);
		errorInfoMap.put(COMMIT_NO_BACKSITE, StringTable.CommitNOBacksite);
		errorInfoMap.put(COMMIT_NO_BACKSITE_OPT, StringTable.CommitNOBacksiteOpt);
		errorInfoMap.put(OUT_OF_PARTICIPATORS, StringTable.OutOfParticipators);
		errorInfoMap.put(COMMIT_NO_TRANSITTO, StringTable.CommitNoTranstTo);
		errorInfoMap.put(PARTICIPATORS_CACL_ERROR, StringTable.ParticipatorsCaclError);
		errorInfoMap.put(DISTRIBUTE_NOT_SUPPORT, StringTable.DistributeNotSupport);
		errorInfoMap.put(TRANSFER_NOT_SUPPORT, StringTable.TransferNotSupport);
		errorInfoMap.put(TRANSITTO_NO_PARTICIPATOR, StringTable.TransitToNoParticipator);
		errorInfoMap.put(DEFAULT_DELEGATE_LOG_USERINFO, StringTable.DefaultDelegateLogUserInfo);
		errorInfoMap.put(DEFAULT_RETREATE_DELEGATE_LOG_USERINFO, StringTable.DefaultRetreateDelegateLogUserInfo);
		errorInfoMap.put(NOT_ALLOWED_REVOKE, StringTable.NotAllowedRevoke);
		errorInfoMap.put(MESSAGE_SEND_ERROR, StringTable.MessageSendError);
		errorInfoMap.put(MESSAGE_NOT_SUPPORT, StringTable.MessageNotSupport);
		errorInfoMap.put(NO_PARTICIPATOR_AUTO_IGNORE_NOT_SUPPORT, StringTable.NoParticipatorAutoIgnoreNotSupport);
		errorInfoMap.put(COMMIT_NO_STRAIGHTSITE, StringTable.CommitNOStraightsite);
		errorInfoMap.put(OPERATOR_DISACCORD, StringTable.OperatorDisaccord);
		errorInfoMap.put(NO_REVOKE_WORKITEM, StringTable.NoRevokeWorkitem);
		errorInfoMap.put(REVOKE_NO_PARTICIPATOR, StringTable.RevokeNoParticipator);
		errorInfoMap.put(NODE_NOT_EXECDATAMAP, StringTable.NodeNotExecdatamap);
		errorInfoMap.put(NO_INLINE_PROCESS_KEY, StringTable.NoInlineProcessKey);
		errorInfoMap.put(NOT_ALLOWED_HOT_DEPLOY_LOW_VERSION, StringTable.NotAllowedHotDeployLowVersion);
		errorInfoMap.put(NOT_ALLOWED_REVOKE_DEPLOY_HIGH_VERSION, StringTable.NotAllowedRevokeDeployHighVersion);
		errorInfoMap.put(NO_TARGET_PROCESS_OF_DEPLOY, StringTable.NoTargetProcessOfDeploy);
		errorInfoMap.put(NO_PROCESSKEY_OR_VERID, StringTable.NoProcessKeyOrVerID);
		errorInfoMap.put(NOT_ALLOWED_HOT_DEPLOY, StringTable.NotAllowedHotDeploy);
		errorInfoMap.put(NOT_ALLOWED_REVOKE_DEPLOY, StringTable.NotAllowedRevokeDeploy);
		errorInfoMap.put(REPEAT_PROCESS_DEPLOY, StringTable.RepeatProcessDeploy);
		errorInfoMap.put(DATA_TYPE_ERROR, StringTable.DataTypeError);
		errorInfoMap.put(REPEAT_PROCESS_SAVE, StringTable.RepeatProcessSave);
		errorInfoMap.put(NOT_ALLOWED_DELETE_DEPLOYED_PROCESS, StringTable.NotAllowedDeleteDeployProcess);
		errorInfoMap.put(PARTICIPATOR_EXIST, StringTable.ParticipatorExist);
	}

	private BPMError(int code, String message) {
		super(code, message);
	}

	@Override
	protected int getGroupCode() {
		return 0x8009;
	}

	public static String formatMessage(ILocale locale, int code, Object... args) {
		String message = null;
		String format = null;
		String info = errorInfoMap.get(code);
		format = StringTable.getString(locale, "", info);
		message = SimpleStringFormat.format(format, args);
		return message;
	}

	public static final BPMError getBPMError(ILocale locale, int code, Object... args) {
		String message = formatMessage(locale, code, args);
		return new BPMError(code, message);
	}

}
