/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.fill;

import com.bokesoft.yes.report.datasource.IImplReportDataSource;
import com.bokesoft.yes.report.fill.FillContext;
import com.bokesoft.yes.report.fill.FillPageTrace;
import com.bokesoft.yes.report.fill.FillSectionTrace;
import com.bokesoft.yes.report.fill.FillTableTrace;
import com.bokesoft.yes.report.fill.FillTemplateTrace;
import com.bokesoft.yes.report.output.OutputSection;
import com.bokesoft.yes.report.template.ReportSection;

public abstract class BaseFillTablePolicy {
    protected FillContext context = null;
    protected FillTableTrace tableTrace = null;
    protected IImplReportDataSource dataSource = null;
    protected FillTemplateTrace templateTrace = null;
    protected FillPageTrace pageTrace = null;

    public void fill(FillSectionTrace fillSectionTrace) throws Throwable {
        ReportSection reportSection = fillSectionTrace.getSection();
        this.tableTrace = fillSectionTrace.getTableTrace();
        this.tableTrace.setPageBreakPolicy(reportSection.getPageBreakPolicy());
        BaseFillTablePolicy baseFillTablePolicy = this;
        baseFillTablePolicy.prepareTableData(baseFillTablePolicy.context, this.tableTrace);
        this.pageTrace.getPage();
        do {
            if ((fillSectionTrace = this.tableTrace.getOutputSection()) == null) {
                fillSectionTrace = new OutputSection();
                this.fillColumns((OutputSection)fillSectionTrace, reportSection);
                this.tableTrace.setOutputSection((OutputSection)fillSectionTrace);
            }
            switch (this.tableTrace.getCurPartIndex()) {
                case 0: {
                    this.fillTitleHead(reportSection);
                    break;
                }
                case 1: {
                    this.fillDetailHead(reportSection);
                    break;
                }
                case 2: {
                    this.fillTopParagraph(reportSection);
                    break;
                }
                case 3: {
                    this.fillBody(reportSection);
                    break;
                }
                case 4: {
                    this.fillBottomParagraph(reportSection);
                    break;
                }
                case 5: {
                    this.fillDetailTail(reportSection);
                    break;
                }
                case 6: {
                    this.fillTitleTail(reportSection);
                }
            }
        } while (this.hasMore());
        if (fillSectionTrace.getRowCount() > 0) {
            this.context.getPageTrace().getPage().addSection((OutputSection)fillSectionTrace);
        }
        this.templateTrace.step();
    }

    private boolean hasMore() {
        return this.tableTrace.getCurPartIndex() < 6;
    }

    protected abstract void prepareTableData(FillContext var1, FillTableTrace var2) throws Throwable;

    protected abstract void fillColumns(OutputSection var1, ReportSection var2);

    protected abstract void fillTitleHead(ReportSection var1);

    protected abstract void fillDetailHead(ReportSection var1);

    protected abstract void fillTopParagraph(ReportSection var1);

    protected abstract void fillLinkPrev(ReportSection var1);

    protected abstract void fillBottomParagraph(ReportSection var1);

    protected abstract void fillBody(ReportSection var1);

    protected abstract void fillDetailTail(ReportSection var1);

    protected abstract void fillTitleTail(ReportSection var1);
}

