/**
 * @author chenbb
 * 
 * 抽象封装Html Dom Element 对象
 */
export default abstract class AbstractDomElement {

    protected el: HTMLElement;

    protected children: AbstractDomElement[] = [];

    constructor(el?: HTMLElement | null) {
        this.el = el || this.createEl();
    }

    setText(caption: string): void {
        this.el.innerText = caption;
    }

    getText(): string {
        return this.el.innerText;
    }

    setHeight(height: number) {
        this.setStyle("height", height + "px");
    }

    setWidth(width: number) {
        this.setStyle("width", width + "px")
    }

    setStyle(key: any, value: any): void {
        this.el.style[key] = value;
    }

    setStyles(styles: any) {
        for (var key in styles) {
            this.setStyle(key, styles[key]) ;
        }
    }

    addClass(cls:string):void {
        if (cls) {
            this.el.classList.add(cls);
        }
    }

    removeClass(cls:string):void {
        this.el.classList.remove(cls);
    }

    toggleClass(cls:string): void {
        this.el.classList.toggle(cls);
    }

    protected createEl(tag:string='div'): HTMLElement {
        return document.createElement(tag);
    }
 
    public getEl(): HTMLElement {
        return this.el;
    }

    public addChild(child?: AbstractDomElement): void {
        if (child) {
            this.children.push(child);
            this.mountChild(child);
        }
    }

    public removeChild(child?: AbstractDomElement): void {
        if (child) {
            var index = this.children.indexOf(child); 
            if (index>= 0) { 
                this.children.splice(index, 1); 
            }
            this.unmountChild(child);
        }
    }

    public getChildAt(index: number): AbstractDomElement {
        return this.children[index];
    }

    public getChildren(): AbstractDomElement[] {
        return this.children;
    }

    public clearChildren(): void {
        for (let child of this.children) {
            this.unmountChild(child);
        }
        this.children = [];
    }

    private mountChild(child: AbstractDomElement | null) {
        child && this.el.appendChild(child.getEl());
    }

    private unmountChild(child: AbstractDomElement) {
        if (child && this.el.contains(child.getEl())) {
            this.el.removeChild(child.getEl());
        }
    }

    addEventListener(name: string, fun: any, useCapture: boolean = false) {
        this.el.addEventListener(name, fun, useCapture);
    }

    findElement(el: HTMLElement | null): AbstractDomElement | null {
        if (!el) {
            return null;
        }
        if (this.getEl() == el) {
            return this;
        }
        if (this.getChildren() != null) {
            for (let child of this.getChildren()) {
                var find = child.findElement(el);
                if (find != null) return find;
            }
        }
        return null;
    }

    resize(width:number, height:number) {
    }

    fireResized(width:number, height:number) {}

    lostFocus() {}
}