export default class VariantUtils {
    
    static D_DEFAULT: string = "Default";

    static async saveVariant(formKey: string, variantPrefix: string, variantName: string | undefined, vairantContent: string, initVariantData: string) {
        var paras = {
            service: "RichDocument",
            cmd: "SaveVariant",
            formKey: formKey,
            variantPrefix: variantPrefix,
            variantName: variantName ? variantName : "",
            content: vairantContent,
            initVariantData: initVariantData
        };
        return await new Svr.Request().getData(paras);
    }

    static async getVariantContent(variantPrefix: string, initVariantData: string, variantName?: string): Promise<any> {
        var paras = {
            service: "RichDocument",
            cmd: "GetVariantContent",
            variantPrefix: variantPrefix,
            initVariantData: initVariantData,
            variantName: variantName ? variantName : ""
        };
        return await new Svr.Request().getData(paras);
    }


    static async getDefaultVariantName(variantPrefix: string): Promise<any> {
        var paras = {
            service: "RichDocument",
            cmd: "GetDefaultVariantName",
            variantPrefix: variantPrefix
        };
        return await new Svr.Request().getData(paras);
    } 
}