import JTreeItem from "../../../../../../common/component/tree/base/item/JTreeItem";
import JTree from "../../../../../../common/component/tree/base/JTree";
import TreeModel from "../../../../../../common/component/tree/base/model/TreeModel";
import DomUtil from "../../../../../../common/dom/DomUtil";
import Events from "../../../../../../common/event/Events";
import { IItemData } from "../../../../../../common/struct/DataStruct";

export default class ComponentLocatorTree extends JTree {

    constructor() {
        super(new TreeModel());
    }

    /**
     * 重定义原始的点击事件
     */
    protected init(): void {
        this.addEventListener("click", (e: any) => {
            var el: HTMLElement | null =  DomUtil.findParentElByTagName(e.target, "LI");
            /*var node = DomUtil.queryElement(this.getDomElement(), el);
            if (node instanceof JTreeItem) {
                var treeItem: JTreeItem = <JTreeItem> node;
                // 针对有子明细的情况，先通过单击事件将触发焦点定位到行，然后再收集检查不通过的子明细行
                this.emitter.emit(Events.Tree.ITEM_CLICK, treeItem);
            }*/
        }, true);
    }

    addItem(data: IItemData): void {
        var itemModel = this.getModel().createTreeItemModel(data);
        this.getModel().addItem(itemModel);
    }
}

   