import JComponent from "../../../../../common/component/JComponent";
import DivElement from "../../../../../common/dom/element/DivElement";
import Events from "../../../../../common/event/Events";
import ComponentLocatorView from "./ComponentLocatorView";
import FormErrorCollector from "./FormErrorCollector";

/**
 * 显示在表单上标志存在错误信息的占位符(红三角)
 */
export default class ComponentRuleLocator extends JComponent<DivElement> {

    private form: YIUI.UIForm;

    private static locatorView: ComponentLocatorView = new ComponentLocatorView();

    private curMouseTimer: any;

    private curStateCheckTimer: any;

    constructor(form: YIUI.UIForm) {
        super(new DivElement());
        this.form = form;
        form.getRoot().getEl().append($(this.getEl()));
        this.addClass('yg-locator-symbol');
        this.setDisplay(false);

        var self = this;
        this.addEventListener(Events.MouseOver, (event: any) => {
            if (this.curMouseTimer) clearTimeout(this.curMouseTimer);
            this.showLocatorView();
        }, true);

        this.addEventListener(Events.MouseOut, (event: any) => {
             this.curMouseTimer = setTimeout(function (){
                self.hideLocatorView();
                self.curMouseTimer = undefined;
            }, 500);
        }, true);
    }

    showLocatorView(): void {
        ComponentRuleLocator.locatorView.showLocatorView(this.form, 0, -5, 250, 400, this.getEl());
    }

    hideLocatorView(): void {
        ComponentRuleLocator.locatorView.hide();
    }

    updateState(): void {
        //console.log("rule locator update state prepare call!");
        if (!this.curStateCheckTimer) {
            this.curStateCheckTimer = setTimeout(() => {
                try {
                    //console.log("rule locator update state prepare execute start!");
                    this.setDisplay(FormErrorCollector.hasError(this.form));
                    //console.log("rule locator update state prepare execute end!");
                } finally {
                    this.curStateCheckTimer = undefined;
                }
            }, 2000);
        }
    }
}
