
export default class TableUtils {

    /**
     * 根据oid取值, 查找所有行（包括被过滤、删除的行）
     * @param oid
     * @param table
     * @returns 
     */
    static getValueByOID(key:string, oid: number, table: DataDef.DataTable): any {
        var indexOfKey = table.indexByKey(key);
        var indexOfOID = table.indexByKey(YIUI.SystemField.OID_SYS_KEY);

        var allRows = table.allRows;
        if (allRows) {
            for (let row of allRows) {
                if(oid == row.vals[indexOfOID]) {
                    return row.vals[indexOfKey];
                }
            }
        }
        return null;
    }
}