import { IGridFindResult } from "../../../../common/struct/Structs";

export default class GridUtils {

    static findResult(findText: string, grid: YIUI.Control.Grid): IGridFindResult {
        var cells = [];
        var rowCount = grid.getRowCount();
        for (var row = 0; row < rowCount; row++) {
            var columnCount = grid.getColumnCount();
            for (var col = 0; col < columnCount; col++) {
                var columnInfo = grid.getColumnAt(col);
                if (!columnInfo.hidden) {
                    var data = grid.getCellDataAt(row, col);
                    var cellText = data ? data[1] : "";
                    GridUtils.matchFindText(cellText, findText) && cells.push({ "row": row, "col": col });
                }
            }
        }
        return {"content": findText, "pos": -1, "cells": cells };
    }

    static clearFindStyle(grid: YIUI.Control.Grid): void {
        var $el = grid.getEl();
        $el && $('tr', $el).removeClass('find-row-style');
        $el && $('td', $el).removeClass('find-cell-style');
    }

    static clearFindFocusStyle(grid: YIUI.Control.Grid): void {
        var $el = grid.getEl();
        $el && $('td', $el).removeClass('find-focusCell-style');
    }
    
    static matchFindText(cellText: string, findText: string): boolean {
        if (!cellText || !findText ) return false;
        return cellText.indexOf(findText) > -1;
    }

    static isGridColumnVisible(columnkey: string, grid: YIUI.Control.Grid): boolean {
        var columnInfo = GridUtils.getGridColumnInfo(columnkey, grid.dataModel.columns);
        if (columnInfo) {
            return columnInfo.visible;
        }
        return false; 
    }

    static getGridColumnInfo(columnKey: string, columns: YIUI.ColumnInfo[]): YIUI.ColumnInfo | null {
        for (let i = 0; i < columns.length; i++) {
           if (columnKey == columns[i].key) {
                return columns[i];
           }
        }
        return null; 
    }

    static populate(pageIndex: number, grid: YIUI.Control.Grid): void {
        grid.impl.el.$table[0].populate(pageIndex);
    }

    static populateVisible(grid: YIUI.Control.Grid): void {
        grid.impl.el.$table[0].grid.populateVisible();
    }

    static scrollVisibleCell(rowIndex: number, columnIndex: number, grid: YIUI.Control.Grid): void {
        grid.impl.el.$table[0].scrollVisibleCell();
    }

    static getCurPageIndex(grid: YIUI.Control.Grid) {
        return grid.getEl().$table[0].p.page - 1;
    }

    static setCellFocus(rowIndex: number, columnIndex: number, grid: YIUI.Control.Grid): void {
        grid.getEl() && grid.getEl().setCellFocus(rowIndex, columnIndex);
    }

    static async selectRow(rowIndex: number, grid: YIUI.Control.Grid): Promise<void> {
        grid.impl.el.$table[0].selectGridRow(0, rowIndex, 0, rowIndex, rowIndex, 0, false);
        await grid.impl.settings.rowChanged(rowIndex, -1);
    }

    static getForm(grid: YIUI.Control.Grid): YIUI.UIForm {
        var formID = grid.ofFormID;
        var form = YIUI.FormStack.getForm(formID);
        return form;
    }

    static getGridVariantCache(grid: YIUI.Control.Grid): any {
        var formID = grid.ofFormID;
        var form = YIUI.FormStack.getForm(formID);
        var doc = form.getDocument();
        if (doc.gridSettingVariants) {
            return doc.gridSettingVariants[grid.key];
        }
        return undefined;
    }

    static cacheGridVariantCache(grid: YIUI.Control.Grid, variant: any): any {
        var formID = grid.ofFormID;
        var form = YIUI.FormStack.getForm(formID);
        var doc = form.getDocument();
        doc.gridSettingVariants = doc.gridSettingVariants || {};
        doc.gridSettingVariants[grid.key] = variant;
    }
}