import Collapse from "../../../../../common/component/control/Collapse";
import VNodeXElement from "../../../../../common/dom/xelement/vnode/VNodeXElement";
import GlobalStyle from "../../../../../common/style/GlobalStyle";
import StringBuilder from "../../../../../common/util/StringBuilder";
import StringUtil from "../../../../../common/util/StringUtil";
import AbstractGridPanelCollapsibleHandler from "./AbstractGridPanelCollapsibleHandler";

export default class GridPanelCollapsibleHandlerForVNode extends AbstractGridPanelCollapsibleHandler {

    private rowsVisible: boolean[] = [];
    private orgRowsHeight: string[] = [];

    constructor(gridPanel: YIUI.Panel.GridLayoutPanel) {
        super(gridPanel);
        var arrRowDefines = this.getRowDefines(gridPanel);
        for (var i = 0; i < arrRowDefines.length; i++) {
            this.rowsVisible[i] = true;
            this.orgRowsHeight[i] = arrRowDefines[i];
        }
    }

    renderCollapseControl(control: Collapse): void {
        let vPanel = this.gridPanel.getEl();
        if (!vPanel) return;
        var vRowIndex = control.getY() + 1;
        var vColIndex = control.getX() + 1;

        var vCollapseCell: VNodeXElement | undefined;
        vPanel.getChildElms().forEach((vCell: any, idx: number) => {
                if (vCell.getAttr('_row') == vRowIndex && vCell.getAttr('_col') == vColIndex) {
                    vCollapseCell = new VNodeXElement(vCell);
                }
            }
        );

        if (!vCollapseCell) {
            vCollapseCell = new VNodeXElement(YIUI.YElement.buildFromVNode(YIUI.h("div")));
            vCollapseCell.setAttribute('_row', vRowIndex);
            vCollapseCell.setAttribute('_col', vColIndex);
            vCollapseCell.addClass('ui-control ui-lbl ui-readonly');
            vCollapseCell.setStyle('grid-row-start', vRowIndex);
            vCollapseCell.setStyle('grid-column-start', vColIndex);
            vCollapseCell.setStyle('display', 'grid');
            vCollapseCell.appendTo(new VNodeXElement(vPanel));
        }

        vCollapseCell.getImpl().addPostpatchHook(() => {
            vCollapseCell && vCollapseCell.getHtmlElement() && control.getDomElement().appendTo(vCollapseCell.getHtmlElement());
        });

        //control.getEl().appendTo(vCollapseCell);
    }

    updateRowVisible(row: number, visible: boolean): void {
        let vPanel = this.gridPanel.getEl();
        vPanel.getChildElms().forEach((vCell: any, idx: number) => {
            if (vCell.getAttr('_row') == row + 1) {
                if (visible) {
                    vCell.$removeClass(GlobalStyle.CLS_AREA_CELL_COLLAPSED);
                } else {
                    vCell.$addClass(GlobalStyle.CLS_AREA_CELL_COLLAPSED);
                }
            }
        });
        this.rowsVisible[row] = visible;
    }

    updatePanel(): void {
        var sb = new StringBuilder();
        for (let i = 0; i < this.rowsVisible.length; i++) {
            if (this.rowsVisible[i]) {
                sb.append(this.orgRowsHeight[i]).append(" ");
            } else {
                sb.append("0px").append(" ");
            }
        }
        var sNewGridTemplateRows = sb.toString().trim();
        this.gridPanel.getEl().$addStyle('grid-template-rows', sNewGridTemplateRows);
    }

    private getRowDefines(gridPanel: YIUI.Panel.GridLayoutPanel): string[] {
        var sGridTemplateRows = gridPanel.getEl().getStyle('grid-template-rows');
        if (sGridTemplateRows) {
            var arrRowDefines = StringUtil.split(sGridTemplateRows.trim(), " ");
            return arrRowDefines;
        } else {
            return [];
        }
    }
}