import Collapse from "../../../../../common/component/control/Collapse";
import ArrayList from "../../../../../common/struct/ArrayList";
import AbstractGridPanelCollapsibleHandler from "./AbstractGridPanelCollapsibleHandler";

export default class GridPanelCollapsibleHandlerForTableVNode extends AbstractGridPanelCollapsibleHandler {

    private rowsVisible: Map<number, boolean>;

    private collapses: ArrayList<Collapse>;

    constructor(gridPanel: YIUI.Panel.GridLayoutPanel) {
        super(gridPanel);
        this.collapses = new ArrayList<Collapse>();
        this.rowsVisible = new Map();
    }

    renderCollapseControl(control: Collapse): void {
        if (!this.collapses.contain(control)) {
            this.collapses.add(control);
        }
    }

    updateRowVisible(row: number, visible: boolean): void {
        this.rowsVisible.set(row, visible);    
    }
    
    updatePanel(): void {
        this.gridPanel.getEl().addPostpatchHook(() => {
            for (let control of this.collapses.getList()) {
                var row = control.getY();
                var rowSelector = `table tr[row='${row}']`;
                var $row = $(rowSelector, this.gridPanel.getEl().getElm());
                var col = control.getX();
                var cellSelector = `td[col='${col}']`;
                var $cell = $(cellSelector, $row);
                if ($cell && $cell[0] && !$cell[0].contains(control.getEl())) {
                    control.render($cell[0]);
                }
            }
            for (const [row, visible] of this.rowsVisible) {
                var rowSelector = `table tr[row='${row}']`;
                var $row = $(rowSelector, this.gridPanel.getEl().getElm());
                $row.css('display', visible ? '': 'none');
            }
        });
    }
}