import { EDesignMode } from "../../../../../common/enum/Enums";
import ActionNames from "../../../../../common/event/ActionNames";
import IWorkSpace from "../../../../../common/workspace/IWorkSpace";
import IXmlEntity from "../../../../../common/xml/IXmlEntity";
import XmlEntityUtil from "../../../../../common/xml/util/XmlEntityUtil";
import BPMNWorkSpace from "../../../../../design/bpm/BPMNWorkSpace";
import DataMapWorkSpace from "../../../../../design/datamap/DataMapWorkSpace";
import DataMigrationWorkSpace from "../../../../../design/datamigration/DataMigrationWorkSpace";
import ExcelWorkSpace from "../../../../../design/excel/ExcelWorkSpace";
import PrintWorkSpace from "../../../../../design/print/PrintWorkSpace";
import FormOperationExecutor from "../../../../design/form/FormOperationExecutor";
import {AreaDesignerOption, DesignerOption} from "../../../../design/interfaces/Options";
import AreaWorkBench from "../../../../design/grouparea/AreaWorkBench";

export default abstract class YesCustomDesigner extends YIUI.YesBaseComponent {

    private  workSpace?: IWorkSpace;

    constructor(options: any) {
        super(options);
    }

    createHtml(): void{
        console.log("....................................");
        this.el.addPostpatchHook(() => {
            var elm = this.el.getElm();
            var form = YIUI.FormStack.getForm(this.owner.ofFormID)
            if(this.owner.userData == "ExtraLayoutDesigner"){
                let option: AreaDesignerOption = {
                    parentEl: elm,
                    form: form,
                    designform: ERPDESIGNER.UI.getActiveERPForm(),
                    panelKey:  ERPDESIGNER.selectedComponentKey
                }
                this.workSpace = this.openAreaSpace(option);
            }else {
                let option: DesignerOption = {
                    //@ts-ignore
                    type: this.owner.userData,
                    parentEl: elm,
                    form: form,
                    mode: this.getMode(),
                    enable: this.owner.enable,
                    xml: this.owner.getValue(),
                    component: this.owner
                }
                this.workSpace = this.openWorkSpace(option);
            }
        });
    }

    install(){
        console.log("++++++++++++++++++++++++++++++++++++++");
    }

    setValue(value: any) {
        this.value = value;
        if (this.workSpace) {
            this.workSpace.load(value);
            value && this.prepareXmlChangeListener(this.workSpace.getXmlEntity());
        }
    }

    getValue(): any {
        return this.value;
    }

    getMode(): EDesignMode {
        return EDesignMode.Dev;
    }

    setHeight(height: number) {
        this.workSpace && this.workSpace.updateLayout();
    }

    setWidth(width: number) {
        this.workSpace && this.workSpace.updateLayout();
    }

    setVisible(bVisible: boolean) {
        this.workSpace && this.workSpace.setDisplay(bVisible);
    }

    setEnable(bEnable: boolean) {
        if (this.workSpace) {
            this.workSpace.setEditable(bEnable);
            this.workSpace.updateLayout();
            bEnable && XmlEntityUtil.refreshSelection(this.workSpace.getXmlEntity());
        }
    }

    openAreaSpace(options: AreaDesignerOption): any{
        var activeForm = ERPDESIGNER.UI.getActiveERPForm();
        var comp = activeForm.getComponent(options.panelKey);
        if (!comp) return;
        var gridPanel = <YIUI.Panel.GridLayoutPanel> comp;
        var areaSpace  = new AreaWorkBench(gridPanel);
        var formExecutor = new FormOperationExecutor(options.form, EDesignMode.Dev);
        formExecutor.setEditable(true);
        areaSpace.setOperationExecutor(formExecutor);

        var parent = options.parentEl;
        parent.appendChild(areaSpace.getEl());
        areaSpace.doLayout(parent);
        areaSpace.doSelectRoot();
        this.prepareXmlChangeListener(areaSpace.getXmlEntity());
        return areaSpace;
    }

    openWorkSpace(options: DesignerOption): IWorkSpace {
        var mode: EDesignMode = options.mode;
        if (window.YIUI && YIUI.isDesignMode) mode = EDesignMode.Local;
        var workSpace: IWorkSpace;
        if (options.type == 'bpmn') {
            workSpace = new BPMNWorkSpace(mode);
        } else if (options.type == 'print') {
            workSpace = new PrintWorkSpace(mode);
        } else if (options.type == 'excel') {
            workSpace = new ExcelWorkSpace(mode);
        } else if (options.type == 'datamigration') {
            //@ts-ignore
            workSpace = new DataMigrationWorkSpace(mode, options.form.WebMapPath);
        } else if (options.type == 'datamap') {
            //@ts-ignore
            workSpace = new DataMapWorkSpace(mode, options.form.WebMapPath);
        } else {
            workSpace = new BPMNWorkSpace(mode);
        }

        // 载入时调用的公式需要获取workspace
        options.component && (options.component.custom = {workspace: workSpace});
        workSpace.doLayout(options.parentEl);

        var form = options.form;
        if (form) {
            var formExecutor = new FormOperationExecutor(form, mode);
            workSpace.setOperationExecutor(formExecutor);
            workSpace.setEditable(options.enable);
        }
        workSpace.load(options.xml);
        this.prepareXmlChangeListener(workSpace.getXmlEntity());
        return workSpace;
    }

    private prepareXmlChangeListener(xmlEntity: IXmlEntity): void {
        xmlEntity.addEventListener({notifyEvent: (cmd, paras) => {
                if (cmd != ActionNames.model_node_update_select && cmd !=  ActionNames.model_node_update_multi_select) {
                    if (this.workSpace) {
                        var xml = this.workSpace.toXml(true);
                        this.owner && this.owner.setValue(xml, true, false);
                    }
                }
            }});
    }
}


/*
class Test extends YIUI.YesBaseComponent{


    createHtml(){
        this.container = document.createElement("div");
        this.container.className = "content";
        const user = YIUI.I18N.getString("LOGIN_USERNAME", "用户名");
        const password = YIUI.I18N.getString("LOGIN_PASSWORD", "密码");
        const html_login = '<span class="username">' + user + '</span><div class="login-user"><input type="text" placeholder=' + user + ' /></div>' +
            '<span class="password">' + password + '</span><div class="login-psd"><input type="password" placeholder=' + password + ' /><span class="show-switch closed"></span></div>' +
            '<div class="login-btns"><button class="login">' + YIUI.I18N.getString("LOGIN_LOGINBTN", "登录") + '</button><button class="reset">' + YIUI.I18N.getString("DIALOG_RETURN", "返回") + '</button></div>';

        this.container.innerHTML = html_login;
        this.el.addPostpatchHook(() => {
            this.el.getElm()?.appendChild(this.container);
        });
    }

    install(){
        var login = this.container.querySelector(".login");
        login.addEventListener("click", function(){
            alert("登录按钮");
        })
    }

    getElm(){
        return this.el.getElm();
    }
}
*/