import { AreaDesignerOption, DesignerOption } from "./Options";

export default interface IDesigner {

    (): void;

    openWorkSpace(options: DesignerOption): any;

    openAreaSpace(options: AreaDesignerOption): any;

    /** 渲染属性面板 */
    renderPropertyPanel(parent: HTMLElement, panel: YIUI.Panel): void;

    /** 渲染可收缩面板的桩控件 */
    renderCollapsiblePanel(panel: YIUI.Panel): void;

    formatXml(content: string): string;

    loadGridSettingVariant(grid:YIUI.Control.Grid): void;

    saveGridSettingVariant(grid: YIUI.Control.Grid): void;

    clearSearchStyle(grid: YIUI.Control.Grid): void;

    /** 安装树表格中的文本搜索插件 */
    installGridSearchPlugin(grid: YIUI.Control.Grid): void;

    /** 安装控件定位插件 */
    installComponentLocator(form: YIUI.UIForm): void;

    locateComponent(compKey: string, form: YIUI.UIForm): void;

    locateGridCell(gridKey: string, row: number, col: number, form: YIUI.UIForm): void;

    locateGridRow(gridKey: string, rowIndex: number, form: YIUI.UIForm): void

    /** 显示树表格操作 */
    showGridTreeMenu(grid: YIUI.Control.Grid, parent: HTMLElement): void;
    /** 隐藏树表格操作 */
    hideGridTreeMenu(): void;
}
