import JComponent from "../../../../common/component/JComponent";
import DivElement from "../../../../common/dom/element/DivElement";
import SizeInfo from "../../../../common/struct/SizeInfo";
import ITagNode from "../../../../common/xml/node/ITagNode";
import AreaConstants from "../property/AreaConstants";
import SelectRange from "../selection/SelectRange";
import AreaStateDelegate from "../state/AreaStateDelegate";
import AreaHandleControl from "./AreaHandleControl";

export default class GroupArea extends JComponent<DivElement> {

    private handleControl: AreaHandleControl | null = null;

    private selectRange: SelectRange;

    private areaTagNode: ITagNode;

    constructor(areaTagNode: ITagNode, areaStateDelegate: AreaStateDelegate) {
        super(new DivElement());
        this.addClass('area_group');
        this.areaTagNode = areaTagNode;
        this.selectRange = new SelectRange(areaStateDelegate);
        var handleTagNode = areaTagNode.getChild(AreaConstants.NODE_Handle);
        if (handleTagNode) {
            this.handleControl = new AreaHandleControl(this.getCaption(), handleTagNode, areaStateDelegate);
        }
        
        this.getDomElement().addChild(this.selectRange);
        this.setStyle("position", "absolute");
        // this.setStyle("background-color", "pink");
        this.setStyle("border-radius", "10px");
        this.setStyle("opacity", "0.5");
        this.markSelected(false);
    }

    getTagNode(): ITagNode {
        return this.areaTagNode;
    }

    getCaption(): string {
        return this.areaTagNode.getAttributeValue(AreaConstants.ATTR_Caption);
    }

    getStartRow(): number {
        return this.areaTagNode.getAttributeValueInt(AreaConstants.ATTR_StartRow, 0);
    }

    getEndRow(): number {
        return this.areaTagNode.getAttributeValueInt(AreaConstants.ATTR_EndRow, 0);
    }

    getRowCount(): number {
        return this.getEndRow() - this.getStartRow() + 1;
    }

    private left: number = 0;
    private top: number = 0;

    setLocation(left: number, top: number, width: number, height: number) {
        this.left = left;
        this.top = top;
        this.setStyle("left", left + "px");
        this.setStyle("top", top + "px");
        this.setWidth(SizeInfo.valueOfPX(width));
        this.setHeight(SizeInfo.valueOfPX(height));
        this.selectRange.setSize(width, height);
        this.selectRange.setVisible(true);
    }

    setHandleLocation(left: number, top: number, width: number, height: number) {
        if (this.handleControl) {
            this.handleControl.setLocation(left, top, width, height);
        }
    }

    setHandleControl(handleControl: AreaHandleControl): void {
        this.handleControl = handleControl;
    }

    getHandleControl(): AreaHandleControl | null {
        return this.handleControl;
    }

    /**
     * 判定控制点位置是否发生过变化,若发生过变化后续改变区域大小时，不会再重置控制点位置
     */
    isHandleRowChanged(): boolean {
        if (!this.handleControl) return true;
        return this.handleControl.getY() == this.getStartRow() - 1;
    }

    markSelected(b: boolean): void {
        this.selectRange.setVisible(b);
        if (this.handleControl) {
            b ? this.handleControl.addClass('area_handle_select') : this.handleControl.removeClass('area_handle_select');
        }
    }

    containPoint(x: number, y: number): boolean {
        return x > this.left && x < this.left + this.getWidth().getValue()
             && y > this.top && y < this.top + this.getHeight().getValue();
    }

    containRow(row: number): boolean {
        return row >= this.getStartRow() && row <= this.getEndRow();
    }
}


/*

    <ExtraLayout Type="Collapsible">
        <GroupCollection>
            <Group Key="" Caption="" Expanded="true|false" StartRow="" EndRow="">
                <Handle Type="SubAdd|UpDown|Switch|Custom" ExpandStyleClass="" CollapseStyleClass="" X="" Y="" XSpan="" YSpan="" ForeColor="">
                    <Format>
                        <Font Bold="true" Italic="true" Name="Angsana New" Size="11"/>
                    </Format>
                </Handle>
            </Group>
        </GroupCollection>    
    </ExtraLayout>
*/