import AbstractAreaState from "./AbstractAreaState";

export default class ResizeState extends AbstractAreaState {

    private resizePosition?: EResizePosition;

    setTopResize(): void {
        this.resizePosition = EResizePosition.Top;
    }

    setBottomResize(): void {
        this.resizePosition = EResizePosition.Bottom;
    }

    mousedown(e: MouseEvent): void {
        super.mousedown(e);
    }

    mousemove(e: MouseEvent): void {
        if (!this.isLeftMouseButtonDowning()) return;
        var view = this.delegate.getDesignView();
        var {x, y} = this.getPosition(e);

        var area = view.getSelectedArea();
        if (!area) return;
        var areaStartRow = area.getStartRow();
        var areaEndRow = area.getEndRow();
        var resizeLoc = view.hitLocationByXY(x, y);
        if (resizeLoc) {
            switch(this.resizePosition) {
                case EResizePosition.Top:
                    var row = resizeLoc.getRow();
                    view.drawAreaShadow(row, areaEndRow);
                    break;
                case EResizePosition.Bottom:
                    var row = resizeLoc.getRow();
                    view.drawAreaShadow(areaStartRow, row);
                    break;
            }
        }
    }
    
    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        this.getDelegate().getDesignView().hideShadow();
        this.getDelegate().setNormalState();
        this.getDelegate().getDesignView().doResizeCmd();
    }
}

enum EResizePosition {
    Top = "Top",
    Bottom = "Bottom"
}
