import AbstractAreaState from "./AbstractAreaState";

export default class NormalState extends AbstractAreaState {

    private startX = 0;

    private startY = 0;
    
    mousedown(e: MouseEvent): void {
        super.mousedown(e);
        var {x, y} = this.getPosition(e);
        this.startX = x;
        this.startY = y;
    }

    mousemove(e: MouseEvent): void {
        if (this.isLeftMouseButtonDowning()) {}
    }

    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        var {x, y} = this.getPosition(e);
        var view = this.delegate.getDesignView();
        var bClick = Math.abs(x - this.startX) < 1 && Math.abs(y - this.startY) < 1;
        if (bClick) {
            view.doSelect(x, y);
            return;
        }
        view.doAddAreaCmdByXY(this.startX, this.startY, x, y);
    }
}