import AbstractAreaState from "./AbstractAreaState";

export default class MoveState extends AbstractAreaState {

    private startX: number = 0;

    private startY: number = 0;

    mousedown(e: MouseEvent): void {
        super.mousedown(e);
        var {x, y} = this.getPosition(e);
        this.startX = x;
        this.startY = y;
    }

    mousemove(e: MouseEvent): void {
        if (!this.isLeftMouseButtonDowning()) return;
        var view = this.delegate.getDesignView();
        var {offsetX, offsetY} = this.getOffset(e, this.startX, this.startY);
        view.drawMoveShadow(offsetX, offsetY);
    }
    
    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        this.getDelegate().getDesignView().hideShadow();
        var {offsetX, offsetY} = this.getOffset(e, this.startX, this.startY);

        if (offsetX < 1 && offsetY < 1) return;
        
        this.getDelegate().getDesignView().doMoveCmd(offsetX, offsetY);
    }
}
