import AbstractDomElement from "../../../../common/dom/AbstractDomElement";
import SizeInfo from "../../../../common/struct/SizeInfo";

export default class RectHandle extends AbstractDomElement {

    public static HANDLE_SIZE: number = 6;

    constructor(bHandle: boolean = true) {
        super();
        if (bHandle) {
            this.setWidth(RectHandle.HANDLE_SIZE);
            this.setHeight(RectHandle.HANDLE_SIZE);
            this.setStyle("border-color", "rgb(6, 123, 239)");
            this.addClass("rect_handle");
        }
    }

    setWidth(width: number): void {
        this.setStyleWidth(SizeInfo.valueOfPX(width));
    }

    setHeight(height: number): void {
        this.setStyleHeight(SizeInfo.valueOfPX(height));
    }

    setLeft(left: number) {
        this.setStyle("left", left + 'px');
    }
    
    setTop(top: number) {
        this.setStyle("top", top + 'px');
    }
    
}

/*----------------------------------------------------------------
<div class="shape_controller n w" index="0" resizedir="tl" style="border-color: rgb(6, 123, 239); width: 6px; height: 6px; z-index: 7; display: block; left: -4px; top: -4px;"></div>
*/