import ICmd from "../../../../common/cmd/ICmd";
import IXmlEntity from "../../../../common/xml/IXmlEntity";
import ITagNode from "../../../../common/xml/node/ITagNode";
import AreaConstants from "../property/AreaConstants";

export default class ResizeAreaCmd implements ICmd {

    private xmlEntity: IXmlEntity;

    private groupTag: ITagNode;

    private startRow: number = 0;

    private endRow: number = 0;

    private oldStartRow: number = 0;

    private oldEndRow: number = 0;

    private oldHandleY: number = -1;

    constructor(xmlEntity: IXmlEntity, groupTag: ITagNode, startRow: number, endRow: number) {
        this.xmlEntity = xmlEntity;
        this.groupTag = groupTag;
        this.startRow = startRow;
        this.endRow = endRow;
    }

    do(): boolean {
        this.oldStartRow =  this.groupTag.getAttributeValueInt(AreaConstants.ATTR_StartRow, 0);
        this.oldEndRow =  this.groupTag.getAttributeValueInt(AreaConstants.ATTR_EndRow, 0);
        this.groupTag.setAttributeValue(AreaConstants.ATTR_StartRow, String(this.startRow));
        this.groupTag.setAttributeValue(AreaConstants.ATTR_EndRow, String(this.endRow));

        var handleTag = this.groupTag.getChild(AreaConstants.NODE_Handle);
        if (handleTag) {
            this.oldHandleY = handleTag.getAttributeValueInt(AreaConstants.ATTR_Y, 0);
            if (this.oldStartRow - 1 == this.oldHandleY) {
                handleTag.setAttributeValue(AreaConstants.ATTR_Y, String(this.startRow - 1));
            }
        }
        this.xmlEntity.update(this.groupTag, false);
        return true;
    }

    undo(): void {
        this.groupTag.setAttributeValue(AreaConstants.ATTR_StartRow, String(this.oldStartRow));
        this.groupTag.setAttributeValue(AreaConstants.ATTR_EndRow, String(this.oldEndRow));
        if (this.oldHandleY > -1) {
            var handleTag = this.groupTag.getChild(AreaConstants.NODE_Handle);
            handleTag && handleTag.setAttributeValue(AreaConstants.ATTR_Y, String(this.oldHandleY));
        }
        this.xmlEntity.update(this.groupTag, false);
    }
}