import ICmd from "../../../../common/cmd/ICmd";
import IXmlEntity from "../../../../common/xml/IXmlEntity";
import ITagNode from "../../../../common/xml/node/ITagNode";
import AreaConstants from "../property/AreaConstants";
import AreaDesignView from './../AreaDesignView';

export default class MoveCmd implements ICmd {

    private moveTag?: ITagNode;

    private xmlEntity: IXmlEntity;

    private offsetDistanceX: number = 0;

    private offsetDistanceY: number = 0;

    private orgX: number = -1;
    private orgY: number = -1;
    private orgY2: number = -1;

    private orgHandleY: number = -1;

    private designView: AreaDesignView;

    constructor(designView: AreaDesignView, offsetDistanceX: number, offsetDistanceY: number) {
        this.designView = designView;
        this.xmlEntity = designView.getXmlEntity();
        this.offsetDistanceX = offsetDistanceX;
        this.offsetDistanceY = offsetDistanceY;
    }

    do(): boolean {
        var selectable = this.xmlEntity.getSelectionModel().getSingleSeletionItem();
        if (!selectable) return false;
        this.moveTag = selectable.getTagNode();
        switch (this.moveTag.getTagName()) {
            case AreaConstants.NODE_Group:
                return this.moveArea(this.moveTag);
            case AreaConstants.NODE_Handle:
                return this.moveHandle(this.moveTag);
        }
        return false;
    }

    moveHandle(handleTag: ITagNode): boolean {
        var handleControl = this.designView.findHandleControl(handleTag);
        if (!handleControl) return false;
        this.orgX = handleControl.getX();
        this.orgY = handleControl.getY();
        var newLeft = this.designView.getLeft(this.orgX) + this.offsetDistanceX + handleControl.getWidth().getValue() / 2;
        var newTop = this.designView.getTop(this.orgY) + this.offsetDistanceY + handleControl.getHeight().getValue() / 2;
        var position = this.designView.hitLocationByXY(newLeft, newTop);
        if (position) {
            var row = position.getRow();
            var col = position.getCol();
            if (col < 0) col = 0;
            this.designView.checkPosition(row , col);
            handleTag.setAttributeValue(AreaConstants.ATTR_X, String(col));
            handleTag.setAttributeValue(AreaConstants.ATTR_Y, String(row));
            this.xmlEntity.update(handleTag, true);
        }
        return true;
    }

    moveArea(areaTag: ITagNode): boolean {
        var area = this.designView.findArea(areaTag);
        if (!area) return false;
        this.orgY = area.getStartRow();
        this.orgY2 = area.getEndRow();
        var newTop = this.designView.getTop(this.orgY) + this.offsetDistanceY + this.designView.getRowHeight(this.orgY) / 2;
        var position = this.designView.hitLocationByXY(10, newTop);
        if (position) {
            var endRow = position.getRow() + area.getRowCount() - 1;
            this.designView.checkAreaMove(position.getRow(), endRow);
            areaTag.setAttributeValue(AreaConstants.ATTR_StartRow, String(position.getRow()));
            areaTag.setAttributeValue(AreaConstants.ATTR_EndRow, String(endRow));

            var handleTag = areaTag.getChild(AreaConstants.NODE_Handle);
            if (handleTag) {
                this.orgHandleY = handleTag.getAttributeValueInt(AreaConstants.ATTR_Y, 0);
                if (this.orgY - 1 == this.orgHandleY) {
                    handleTag.setAttributeValue(AreaConstants.ATTR_Y, String(position.getRow() - 1));
                }
            }
            this.xmlEntity.update(areaTag, true);
        }
        return true;
    }

    undo(): void {
        if (!this.moveTag) return;
        switch (this.moveTag.getTagName()) {
            case AreaConstants.NODE_Group:
                if (this.orgY < 0 || this.orgY2 < 0) return;
                this.moveTag.setAttributeValue(AreaConstants.ATTR_StartRow, String(this.orgY));
                this.moveTag.setAttributeValue(AreaConstants.ATTR_EndRow, String(this.orgY2));

                var handleTag = this.moveTag.getChild(AreaConstants.NODE_Handle);
                if (handleTag && this.orgHandleY > -1) {
                    handleTag.setAttributeValue(AreaConstants.ATTR_Y, String(this.orgHandleY));
                }
                this.xmlEntity.update(this.moveTag, true);
                break;
            case AreaConstants.NODE_Handle:
                if (this.orgY < 0 || this.orgX< 0) return;
                this.moveTag.setAttributeValue(AreaConstants.ATTR_X, String(this.orgX));
                this.moveTag.setAttributeValue(AreaConstants.ATTR_Y, String(this.orgY));
                this.xmlEntity.update(this.moveTag, true);
                break;
        }
    }

}