import ICmd from "../../../../common/cmd/ICmd";
import IXmlEntity from "../../../../common/xml/IXmlEntity";
import ITagNode from "../../../../common/xml/node/ITagNode";

export default class DeleteCmd implements ICmd {

    private deleteTag?: ITagNode;

    private xmlEntity: IXmlEntity;

    constructor(xmlEntity: IXmlEntity) {
        this.xmlEntity = xmlEntity;
    }

    do(): boolean {
        var selectable = this.xmlEntity.getSelectionModel().getSingleSeletionItem();
        if (!selectable) return false;
        this.deleteTag = selectable.getTagNode();
        this.xmlEntity.removeNode(this.deleteTag);
        return true;
    }

    undo(): void {
        if (!this.deleteTag) return;
        this.xmlEntity.addNode(this.deleteTag, this.deleteTag.getParent());
    }

}