import BorderPanel from "../../../common/component/container/panel/BorderPanel";
import IOperatioExecutor from "../../../common/operation/IOperatioExecutor";
import OperationDispatcher from "../../../common/operation/OperationDispatcher";
import SelectionModel from "../../../common/selection/SelectionModel";
import SizeInfo from "../../../common/struct/SizeInfo";
import IWorkSpace from "../../../common/workspace/IWorkSpace";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import { IPropertyContainer, IPropertyPlugin } from "../../../design/plugin/property/base/PropertyDefine";
import PropertyPlugin from "../../../design/plugin/property/PropertyPlugin";
import PropertyUIContainer from "../../../design/plugin/property/ui/PropertyUIContainer";
import AreaDesignView from "./AreaDesignView";
import AreaConstants from "./property/AreaConstants";
import AreaPropertyDefine from "./property/AreaPropertyDefine";

export default class AreaWorkBench extends BorderPanel implements IPropertyContainer<any>, IWorkSpace {

    private areaDesignView: AreaDesignView;

    private propertyPlugin: PropertyPlugin;

    private propertyUIContainer: PropertyUIContainer<any>;

    private operationDispatcher: OperationDispatcher;

    constructor(gridPanel: YIUI.Panel.GridLayoutPanel) {
        super(0, 300, 0, 0);
        this.addClass('area_workbench');
        this.operationDispatcher = new OperationDispatcher();
        this.propertyPlugin = new PropertyPlugin(this.operationDispatcher);
        this.propertyUIContainer = new PropertyUIContainer(this.propertyPlugin);
        this.initProperties();
        this.setRight(this.propertyUIContainer);
        this.areaDesignView = new AreaDesignView(gridPanel, this);
        this.setCenter(this.areaDesignView);
    }
    
    getSelectionModel(): SelectionModel {
        return this.getXmlEntity().getSelectionModel();
    }

    setEditable(b: boolean): void {
    }

    reloadSource(): void {
    }

    getXmlEntity(): IXmlEntity {
        return this.areaDesignView.getXmlEntity();
    }

    getPropertyUIContainer(): PropertyUIContainer<any> {
        return this.propertyUIContainer;
    }

    doSelectRoot(): void {
        this.areaDesignView.doSelectRoot();
    }

    setOperationExecutor(operatioExecutor: IOperatioExecutor): void {
        this.operationDispatcher.setExecutor(operatioExecutor);
    }
    
    /**
     * 属性注册
     */
    private initProperties(): void {
        var PD = AreaPropertyDefine.getInstance();
        this.propertyPlugin.register(AreaConstants.NODE_ExtraLayout, PD.getPropertyDefines(AreaConstants.NODE_ExtraLayout));
        this.propertyPlugin.register(AreaConstants.NODE_Group, PD.getPropertyDefines(AreaConstants.NODE_Group));
        this.propertyPlugin.register(AreaConstants.NODE_Handle, PD.getPropertyDefines(AreaConstants.NODE_Handle));
    }

    private parent?: HTMLElement;

    doLayout(parent: HTMLElement): void {
        this.parent = parent;
        this.reLayout(SizeInfo.valueOfPX(parent.clientWidth), SizeInfo.valueOfPX(parent.clientHeight));
        this.areaDesignView.updateAllView();
    }

    updateLayout() {
        this.parent && this.reLayout(SizeInfo.valueOfPX(this.parent.clientWidth), SizeInfo.valueOfPX(this.parent.clientHeight));
        this.areaDesignView.updateAllView();
    }

    toXml(bSimple: boolean): string {
        return this.areaDesignView.toXml(bSimple);
    }
    
    load(xml: string) {}

    getPropertyPlugin(): IPropertyPlugin {
        return this.propertyUIContainer.getPropertyPlugin();
    }
}