import AbstractDomElement from "../../../../common/dom/AbstractDomElement";
import { IPropertyGroup } from "../../../../design/plugin/property/base/PropertyDefine";
import PropertyStateDelegate from "../../../../design/plugin/property/ui/state/PropertyStateDelegate";
import YigoPropertyUIGroup from "./YigoPropertyUIGroup";
import IPropertyView from './../../../../design/plugin/property/ui/IPropertyView';
import SizeInfo from "../../../../common/struct/SizeInfo";
import DivElement from "../../../../common/dom/element/DivElement";

export default class YigoPropertyUIPanel extends AbstractDomElement implements IPropertyView {

    public static PROP_RATIO: number = 0.5;

    private stateDelegate: PropertyStateDelegate;

    private propertyPanel: AbstractDomElement;

    constructor(propertyGroups: IPropertyGroup[]) {
        super();
        this.setStyle('overflow', 'auto');

        this.propertyPanel = new DivElement();
        this.addChild(this.propertyPanel);
        this.propertyPanel.addClassArray(this.styleFactory.getPropertyPanel());

        this.stateDelegate = new PropertyStateDelegate(this);
        this.init(propertyGroups);
        this.initEvents();
    }

    /**
     * 事件注册
     */
    private initEvents() {
        this.addEventListener('mousedown', (e: MouseEvent) => {
            this.stateDelegate.getCurrentState().mousedown(e);
        });

        this.addEventListener('mousemove', (e: MouseEvent) => {
            this.stateDelegate.getCurrentState().mousemove(e);
        });

        this.addEventListener('mouseup', (e: MouseEvent) => {
            this.stateDelegate.getCurrentState().mouseup(e);
        });
    }
        
    init(propertyGroups: IPropertyGroup[]): void {
        this.preparePropertyGroups(propertyGroups);
        this.propertyPanel.clearChildren();
        if (propertyGroups) {
            for (let group of propertyGroups) {
                var uiGroup = new YigoPropertyUIGroup(group, this.stateDelegate);
                this.propertyPanel.addChild(uiGroup);
            }
        }
    }

    private preparePropertyGroups(propertyGroups: IPropertyGroup[]): void {
        if (propertyGroups) {
            for (let group of propertyGroups) {
                var uiGroup = this.getUIGroup(group.key);
                uiGroup && (group.expanded = uiGroup.isExpanded());
            }
        }
    }

    getUIGroup(groupKey: string): YigoPropertyUIGroup | null {
        for( let child of this.propertyPanel.getChildren()) {
            if (child instanceof YigoPropertyUIGroup) {
                var uiGroup = <YigoPropertyUIGroup> child;
                if (groupKey == uiGroup.getKey()) {
                    return uiGroup;
                }
            }
        }
        return null;
    }

    getInnerHeight(): number {
        var total = 0;
        for( let child of this.propertyPanel.getChildren()) {
            if (child instanceof YigoPropertyUIGroup) {
                var uiGroup = <YigoPropertyUIGroup> child;
                total += uiGroup.getInnerHeight();
            }
        }
        return total;
    }

    resize(width:number, height:number) {
        this.setStyleWidth(SizeInfo.valueOfPX(width));
        this.setStyleHeight(SizeInfo.valueOfPX(height));
        this.resetHeight();
        for( let child of this.propertyPanel.getChildren()) {
            child.resize(this.propertyPanel.getHtmlClientWidth(), height);
        }
    }

    getRatio(): number {
        return YigoPropertyUIPanel.PROP_RATIO;
    }

    setRatio(ratio: number): void {
        YigoPropertyUIPanel.PROP_RATIO = ratio;
        for( let child of this.propertyPanel.getChildren()) {
            if (child instanceof YigoPropertyUIGroup) {
                (<YigoPropertyUIGroup> child).resizeByRatio(ratio);
            }
        }
    }

    resetHeight(): void {
        var realHeight = this.getInnerHeight();
        this.propertyPanel.setStyleHeight(SizeInfo.valueOfPX(realHeight));
    }
}
