import AbstractControl from "../../../../common/component/control/AbstractControl";
import Span from "../../../../common/component/control/Span";
import AbstractDomElement from "../../../../common/dom/AbstractDomElement";
import SizeInfo from "../../../../common/struct/SizeInfo";
import PropertyContants from "../../../../design/plugin/property/base/PropertyContants";
import IPropertyItem from "../../../../design/plugin/property/base/PropertyDefine";
import PropertyStateDelegate from "../../../../design/plugin/property/ui/state/PropertyStateDelegate";
import YigoCombinedControl from "../YigoCombinedControl";
import YigoPropertyUIPanel from "./YigoPropertyUIPanel";

export default class YigoPropertyUIControl extends AbstractDomElement {

    private propertyItem: IPropertyItem;

    private labelControl?: Span;

    private editorControl?: AbstractControl<any>;

    private stateDelegate: PropertyStateDelegate;

    private spanResizer?: Span;

    private curTotalWidth: number = 0;

    private curHeight: number = 0;

    constructor(propertyItem: IPropertyItem, stateDelegate: PropertyStateDelegate) {
        super();
        this.addClass('property-control-line');
        this.setStyle("line-height", PropertyContants.CONTROL_HEIGHT + "px");
        this.stateDelegate = stateDelegate;
        this.propertyItem = propertyItem;
        this.init(propertyItem);
    }

    protected createEl(): HTMLElement {
        return document.createElement("li");
    }

    private init(propertyItem: IPropertyItem) {
        this.labelControl = new Span(propertyItem.caption);
        this.labelControl.setStyle("display", "inline-block");
        this.labelControl.addClass("property-control-base");
        this.labelControl.addClass("property-label");
        this.addChild(this.labelControl.getDomElement());

        this.spanResizer = new Span("");
        this.spanResizer.setStyle("position", "absolute");
        this.spanResizer.setStyle("display", "inline-block");
        this.spanResizer.addClass("property-control-base");
        this.spanResizer.addClass("property-label");
        this.spanResizer.addClass("property-resize-ltr");
        this.addChild(this.spanResizer.getDomElement());

        this.spanResizer.getDomElement().hover(() => {
            this.stateDelegate.setResizeState();
        },() => {
            if (!this.stateDelegate.getCurrentState().isLeftMouseButtonDowning()) {
                this.stateDelegate.setNormalState();
            }
        });

        if (propertyItem.component) {
            //(<YIUI.Component> this.propertyItem.component).doRender($(this.getEl()));
            this.editorControl = new YigoCombinedControl(<YIUI.Component> this.propertyItem.component, this.propertyItem.component2);
            this.editorControl.addClass("property-control-base");
            this.editorControl.addClass("property-input");
            this.addChild(this.editorControl.getDomElement());
        }
    } 

    getPropertyItem(): IPropertyItem {
        return this.propertyItem;
    }

    updateUI(): void {
        this.init(this.propertyItem);
    }

    getInnerHeight(): number {
        return PropertyContants.CONTROL_HEIGHT;
    }

    resize(width:number, height:number) {
        this.curTotalWidth = width;
        this.curHeight = height;
        var leftWidth: number = width * YigoPropertyUIPanel.PROP_RATIO - 6;
        var rightWidth: number = width * (1 - YigoPropertyUIPanel.PROP_RATIO) - 6;
        var curHeight: number = height - 1;
        var leftWidthInfo = SizeInfo.valueOfPX(leftWidth);
        var rightWidthInfo = SizeInfo.valueOfPX(rightWidth);
        var heightInfo = SizeInfo.valueOfPX(curHeight);
        this.labelControl && this.labelControl.setWidth(leftWidthInfo); 
        this.labelControl && this.labelControl.setHeight(heightInfo);

        this.spanResizer && this.spanResizer.setHeight(heightInfo);

        this.editorControl && this.editorControl.setWidth(rightWidthInfo);
        this.editorControl && this.editorControl.setHeight(heightInfo);
        this.editorControl && this.editorControl.fireResized(rightWidthInfo, heightInfo);
        this.editorControl && this.editorControl.lostFocus();
    }

    resizeByRatio(ratio: number): void {
        this.resize(this.curTotalWidth, this.curHeight);
    }
}